/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AutomataScriptInterpreterOverallResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ExceptionOrErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.NonterminatingLassoResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.SyntaxErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TerminationAnalysisResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TerminationArgumentResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.ITimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import java.util.List;
import java.util.Map;

public final class ResultSummarizer {
    private ToolchainResult mSummary;
    private String mDescription;

    public ResultSummarizer(IResultService resultService) {
        this.processResults(resultService.getResults());
    }

    public ResultSummarizer(Map<String, List<IResult>> results) {
        this.processResults(results);
    }

    private void processResults(Map<String, List<IResult>> results) {
        ToolchainResult toolchainResult = ToolchainResult.NORESULT;
        String description = "Toolchain returned no result.";
        for (List<IResult> PluginResults : results.values()) {
            block5: for (IResult result : PluginResults) {
                if (result instanceof SyntaxErrorResult) {
                    toolchainResult = ToolchainResult.SYNTAXERROR;
                    description = result.getShortDescription();
                    continue;
                }
                if (result instanceof UnprovableResult) {
                    if (!toolchainResult.isLess(ToolchainResult.UNPROVABLE)) continue;
                    toolchainResult = ToolchainResult.UNPROVABLE;
                    description = "unable to determine feasibility of some traces";
                    continue;
                }
                if (result instanceof CounterExampleResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.INCORRECT);
                    continue;
                }
                if (result instanceof PositiveResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.CORRECT);
                    continue;
                }
                if (result instanceof ITimeoutResult) {
                    if (!toolchainResult.isLess(ToolchainResult.TIMEOUT)) continue;
                    toolchainResult = ToolchainResult.TIMEOUT;
                    description = "Timeout";
                    continue;
                }
                if (result instanceof GenericResultAtElement) {
                    if (!toolchainResult.isLessOrEqual(ToolchainResult.GENERICRESULT)) continue;
                    toolchainResult = ToolchainResult.GENERICRESULT;
                    description = String.valueOf(result.getShortDescription()) + "  " + result.getLongDescription();
                    continue;
                }
                if (result instanceof AutomataScriptInterpreterOverallResult) {
                    AutomataScriptInterpreterOverallResult autScriptInterpreterResult = (AutomataScriptInterpreterOverallResult)result;
                    toolchainResult = ResultSummarizer.translateAutomataScriptInterpreterOverallResult(autScriptInterpreterResult.getOverallResult());
                    description = result.getLongDescription();
                    continue;
                }
                if (result instanceof NonterminatingLassoResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.INCORRECT);
                    continue;
                }
                if (result instanceof AllSpecificationsHoldResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.CORRECT);
                    continue;
                }
                if (result instanceof TerminationArgumentResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.CORRECT);
                    continue;
                }
                if (result instanceof ExceptionOrErrorResult) {
                    toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.ERROR);
                    continue;
                }
                if (!(result instanceof TerminationAnalysisResult)) continue;
                TerminationAnalysisResult tar = (TerminationAnalysisResult)result;
                switch (tar.getTermination()) {
                    case NONTERMINATING: {
                        toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.INCORRECT);
                        break;
                    }
                    case TERMINATING: {
                        toolchainResult = ResultSummarizer.updateIfLess(toolchainResult, ToolchainResult.CORRECT);
                        break;
                    }
                    default: {
                        if (!toolchainResult.isLess(ToolchainResult.UNPROVABLE)) continue block5;
                        toolchainResult = ToolchainResult.UNPROVABLE;
                        description = "unable to determine termination";
                    }
                }
            }
        }
        this.mSummary = toolchainResult;
        this.mDescription = description;
    }

    private static ToolchainResult updateIfLess(ToolchainResult current, ToolchainResult desired) {
        if (current.isLess(desired)) {
            return desired;
        }
        return current;
    }

    private static ToolchainResult translateAutomataScriptInterpreterOverallResult(AutomataScriptInterpreterOverallResult.OverallResult overallResult) {
        switch (overallResult) {
            case ALL_ASSERTIONS_HOLD: {
                return ToolchainResult.CORRECT;
            }
            case SOME_ASSERTION_FAILED: {
                return ToolchainResult.INCORRECT;
            }
            case TIMEOUT: {
                return ToolchainResult.TIMEOUT;
            }
        }
        return ToolchainResult.NORESULT;
    }

    public ToolchainResult getResultSummary() {
        return this.mSummary;
    }

    public String getResultDescription() {
        return this.mDescription;
    }

    public String getOldResultMessage() {
        switch (this.getResultSummary()) {
            case NORESULT: 
            case UNPROVABLE: 
            case TIMEOUT: 
            case SYNTAXERROR: {
                return ResultSummarizer.programUnknown(this.getResultDescription());
            }
            case INCORRECT: {
                return ResultSummarizer.programIncorrect();
            }
            case CORRECT: {
                return ResultSummarizer.programCorrect();
            }
            case GENERICRESULT: {
                return this.getResultDescription();
            }
        }
        throw new UnsupportedOperationException("unknown result " + (Object)((Object)this.getResultSummary()));
    }

    private static String programCorrect() {
        return "RESULT: Ultimate proved your program to be correct!";
    }

    private static String programIncorrect() {
        return "RESULT: Ultimate proved your program to be incorrect!";
    }

    private static String programUnknown(String text) {
        return "RESULT: Ultimate could not prove your program: " + text;
    }

    public static enum ToolchainResult {
        NORESULT(-1),
        GENERICRESULT(0),
        CORRECT(1),
        UNPROVABLE(2),
        TIMEOUT(3),
        INCORRECT(4),
        SYNTAXERROR(5),
        ERROR(5);

        private int mValue;

        private ToolchainResult(int i) {
            this.mValue = i;
        }

        boolean isLess(ToolchainResult other) {
            return this.mValue < other.mValue;
        }

        boolean isLessOrEqual(ToolchainResult other) {
            return this.mValue <= other.mValue;
        }
    }
}

