/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.DataRaceFoundResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UserSpecifiedLimitReachedResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithLocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ResultUtil {
    private ResultUtil() {
    }

    public static <TE extends IElement, E> List<ILocation> getLocationSequence(IProgramExecution<TE, E> pe) {
        if (pe == null) {
            return Collections.emptyList();
        }
        ArrayList<ILocation> result = new ArrayList<ILocation>();
        int i = 0;
        while (i < pe.getLength()) {
            AtomicTraceElement te = pe.getTraceElement(i);
            result.add(ILocation.getAnnotation((IElement)((IElement)te.getTraceElement())));
            ++i;
        }
        return result;
    }

    public static <E extends IResult> Collection<E> filterResults(Map<String, List<IResult>> results, Class<E> resClass) {
        ArrayList<E> filteredList = new ArrayList<E>();
        for (Map.Entry<String, List<IResult>> entry : results.entrySet()) {
            filteredList.addAll(ResultUtil.filterResults(entry.getValue(), resClass));
        }
        return filteredList;
    }

    public static Collection<IResult> filterResults(Map<String, List<IResult>> results, Predicate<IResult> pred) {
        ArrayList<IResult> filteredList = new ArrayList<IResult>();
        for (Map.Entry<String, List<IResult>> entry : results.entrySet()) {
            filteredList.addAll(ResultUtil.filterResults(entry.getValue(), pred));
        }
        return filteredList;
    }

    public static Map<String, List<IResult>> filterResultMap(Map<String, List<IResult>> results, Predicate<IResult> pred) {
        LinkedHashMap<String, List<IResult>> filteredResults = new LinkedHashMap<String, List<IResult>>();
        for (Map.Entry<String, List<IResult>> entry : results.entrySet()) {
            List newResultList = entry.getValue().stream().filter(pred).collect(Collectors.toList());
            if (newResultList.size() == entry.getValue().size()) {
                filteredResults.put(entry.getKey(), entry.getValue());
                continue;
            }
            filteredResults.put(entry.getKey(), newResultList);
        }
        return filteredResults;
    }

    public static <E extends IResult> Collection<E> filterResults(List<IResult> results, Class<E> resClass) {
        ArrayList<IResult> filteredList = new ArrayList<IResult>();
        for (IResult result : results) {
            if (!resClass.isAssignableFrom(result.getClass())) continue;
            IResult benchmarkResult = result;
            filteredList.add(benchmarkResult);
        }
        return filteredList;
    }

    public static Collection<IResult> filterResults(List<IResult> results, Predicate<IResult> pred) {
        return results.stream().filter(pred).collect(Collectors.toList());
    }

    public static boolean anyMatch(Map<String, List<IResult>> results, Predicate<IResult> pred) {
        return results.entrySet().stream().flatMap(a -> ((List)a.getValue()).stream()).anyMatch(pred);
    }

    public static <SE> String translateExpressionToString(IBacktranslationService translator, Class<SE> clazz, SE[] expression) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < expression.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(translator.translateExpressionToString(expression[i], clazz));
            ++i;
        }
        return sb.toString();
    }

    public static void logResults(ILogger logger, Map<String, List<IResult>> results, boolean appendCompleteLongDescription) {
        if (logger == null || results == null) {
            throw new IllegalArgumentException("logger or results is null");
        }
        List nonEmptyResults = results.entrySet().stream().filter(a -> !((List)a.getValue()).isEmpty()).collect(Collectors.toList());
        if (nonEmptyResults.isEmpty()) {
            return;
        }
        logger.info((Object)" --- Results ---");
        for (Map.Entry entry : nonEmptyResults) {
            logger.info((Object)String.format(" * Results from %s:", entry.getKey()));
            for (IResult result : (List)entry.getValue()) {
                ResultUtil.logResult(logger, result, appendCompleteLongDescription);
            }
        }
    }

    private static void logResult(ILogger logger, IResult result, boolean appendCompleteLongDescription) {
        StringBuilder sb = new StringBuilder();
        sb.append("  - ");
        sb.append(result.getClass().getSimpleName());
        if (result instanceof IResultWithLocation) {
            ILocation loc = ((IResultWithLocation)result).getLocation();
            if (loc.getStartLine() != 0) {
                sb.append(" [Line: ");
                sb.append(loc.getStartLine()).append("]");
            } else {
                sb.append(" [Unknown line] ");
            }
        }
        sb.append(": ");
        sb.append(result.getShortDescription());
        logger.info((Object)sb.toString());
        String[] s = result.getLongDescription().split("\n");
        if (appendCompleteLongDescription) {
            logger.info((Object)String.format("    %s", result.getLongDescription()));
        } else {
            logger.info((Object)String.format("    %s", s[0].replaceAll("\\n|\\r", "")));
            if (s.length > 1) {
                logger.info((Object)"    [...]");
            }
        }
    }

    public static <E extends ICsvProviderProvider<?>> Collection<E> getCsvProviderProviderFromUltimateResults(Map<String, List<IResult>> ultimateIResults, Class<E> benchmarkClass) {
        Collection<StatisticsResult> benchmarks = ResultUtil.filterResults(ultimateIResults, StatisticsResult.class);
        ArrayList filteredList = new ArrayList();
        for (StatisticsResult benchmarkResult : benchmarks) {
            ICsvProviderProvider benchmark = benchmarkResult.getStatistics();
            if (!benchmark.getClass().isAssignableFrom(benchmarkClass)) continue;
            filteredList.add(benchmark);
        }
        return filteredList;
    }

    public static IResult combineLocationResults(IResult oldResult, IResult newResult) {
        if (oldResult instanceof DataRaceFoundResult) {
            return oldResult;
        }
        if (newResult instanceof CounterExampleResult || newResult instanceof DataRaceFoundResult) {
            return newResult;
        }
        if (oldResult instanceof TimeoutResultAtElement || oldResult instanceof UserSpecifiedLimitReachedResultAtElement || oldResult instanceof CounterExampleResult || oldResult instanceof UnprovableResult) {
            return oldResult;
        }
        assert (oldResult instanceof PositiveResult) : "Unsupported location-specific result: " + oldResult;
        return newResult;
    }
}

