/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;

public class TerminationAnalysisResult
extends AbstractResult
implements IResultWithSeverity {
    private final Termination mTermination;
    private final String mLongDescription;

    public TerminationAnalysisResult(String plugin, Termination termination, String longDescription) {
        super(plugin);
        this.mTermination = termination;
        this.mLongDescription = longDescription;
    }

    public Termination getTermination() {
        return this.mTermination;
    }

    public String getShortDescription() {
        String shortDescription;
        switch (this.mTermination) {
            case NONTERMINATING: {
                shortDescription = "Nontermination possible";
                break;
            }
            case TERMINATING: {
                shortDescription = "Termination proven";
                break;
            }
            case UNKNOWN: {
                shortDescription = "Unable to decide termination";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return shortDescription;
    }

    public String getLongDescription() {
        return this.mLongDescription;
    }

    public IResultWithSeverity.Severity getSeverity() {
        IResultWithSeverity.Severity severity;
        switch (this.mTermination) {
            case NONTERMINATING: {
                severity = IResultWithSeverity.Severity.ERROR;
                break;
            }
            case TERMINATING: {
                severity = IResultWithSeverity.Severity.INFO;
                break;
            }
            case UNKNOWN: {
                severity = IResultWithSeverity.Severity.ERROR;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return severity;
    }

    public static enum Termination {
        TERMINATING,
        NONTERMINATING,
        UNKNOWN;

    }
}

