/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;

public class TerminationArgumentResult<P extends IElement, E>
extends AbstractResultAtElement<P> {
    private final String mRankingFunctionDescription;
    private final E[] mRankingFunction;
    private final E[] mSupportingInvariants;
    private final Class<E> mExprClazz;

    public TerminationArgumentResult(P position, String plugin, E[] ranking_function, String rankingFunctionDescription, E[] supporting_invariants, IBacktranslationService translatorSequence, Class<E> exprClazz) {
        super(position, plugin, translatorSequence);
        this.mRankingFunction = ranking_function;
        this.mRankingFunctionDescription = rankingFunctionDescription;
        this.mSupportingInvariants = supporting_invariants;
        this.mExprClazz = exprClazz;
    }

    public String getShortDescription() {
        return "Found " + this.mRankingFunctionDescription + " ranking function";
    }

    public String getLongDescription() {
        E e;
        StringBuilder sb = new StringBuilder();
        sb.append("Found a termination argument consisting of the ");
        sb.append(this.mRankingFunctionDescription);
        sb.append(" ranking function");
        sb.append(": [");
        boolean needsComma = false;
        E[] EArray = this.mRankingFunction;
        int n = this.mRankingFunction.length;
        int n2 = 0;
        while (n2 < n) {
            e = EArray[n2];
            if (needsComma) {
                sb.append(", ");
            } else {
                needsComma = true;
            }
            sb.append(this.mTranslatorSequence.translateExpressionToString(e, this.mExprClazz));
            ++n2;
        }
        sb.append("]");
        if (this.mSupportingInvariants.length > 0) {
            sb.append(" and the following supporting invariants: ");
            EArray = this.mSupportingInvariants;
            n = this.mSupportingInvariants.length;
            n2 = 0;
            while (n2 < n) {
                e = EArray[n2];
                sb.append(this.mTranslatorSequence.translateExpressionToString(e, this.mExprClazz));
                ++n2;
            }
        } else {
            sb.append(" for which no supporting invariant is required.");
        }
        return sb.toString();
    }

    public String getRankingFunctionDescription() {
        return this.mRankingFunctionDescription;
    }

    public E[] getRankingFunction() {
        return this.mRankingFunction;
    }

    public E[] getSupportingInvariants() {
        return this.mSupportingInvariants;
    }
}

