/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnprovabilityReason {
    private final String mDescription;
    private final ILocation mLocation;

    public UnprovabilityReason(String description) {
        this(description, null);
    }

    public UnprovabilityReason(String description, ILocation location) {
        this.mDescription = description;
        this.mLocation = location;
    }

    public String toString() {
        if (this.mLocation == null) {
            return this.mDescription;
        }
        return String.valueOf(this.mDescription) + " at line " + this.mLocation.getStartLine();
    }

    public static <TE extends IElement> List<UnprovabilityReason> getUnprovabilityReasons(IProgramExecution<TE, ?> pe) {
        ArrayList<UnprovabilityReason> unproabilityReasons = new ArrayList<UnprovabilityReason>();
        for (Map.Entry<String, ILocation> entry : Overapprox.getOverapproximations(pe).entrySet()) {
            unproabilityReasons.add(new UnprovabilityReason("overapproximation of " + entry.getKey(), entry.getValue()));
        }
        return unproabilityReasons;
    }
}

