/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovabilityReason;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IFailedAnalysisResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithFiniteTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UnprovableResult<ELEM extends IElement, TE extends IElement, E>
extends AbstractResultAtElement<ELEM>
implements IResultWithFiniteTrace<TE, E>,
IFailedAnalysisResult {
    private final Check mCheckedSpecification;
    private final IProgramExecution<TE, E> mProgramExecution;
    private final List<ILocation> mFailurePath;
    private final List<UnprovabilityReason> mUnprovabilityReasons;
    private String mProgramExecutionAsString;

    public UnprovableResult(String plugin, ELEM position, IBacktranslationService translatorSequence, IProgramExecution<TE, E> programExecution) {
        this(plugin, position, translatorSequence, programExecution, Collections.emptyList());
    }

    public UnprovableResult(String plugin, ELEM position, IBacktranslationService translatorSequence, IProgramExecution<TE, E> programExecution, String unprovabilityReason) {
        this(plugin, position, translatorSequence, programExecution, Collections.singletonList(new UnprovabilityReason(Objects.requireNonNull(unprovabilityReason))));
    }

    public UnprovableResult(String plugin, ELEM position, IBacktranslationService translatorSequence, IProgramExecution<TE, E> programExecution, List<UnprovabilityReason> unprovabilityReasons) {
        super(position, plugin, translatorSequence);
        Check check = Check.getAnnotation(position);
        this.mCheckedSpecification = check == null ? new Check(Check.Spec.UNKNOWN) : check;
        this.mProgramExecution = programExecution;
        this.mFailurePath = ResultUtil.getLocationSequence(programExecution);
        this.mUnprovabilityReasons = Objects.requireNonNull(unprovabilityReasons);
    }

    public Check getCheckedSpecification() {
        return this.mCheckedSpecification;
    }

    public String getShortDescription() {
        return "Unable to prove that " + this.mCheckedSpecification.getPositiveMessage();
    }

    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append(this.getReasons());
        if (this.mProgramExecution != null) {
            sb.append(CoreUtil.getPlatformLineSeparator());
            sb.append("Possible FailurePath: ");
            sb.append(CoreUtil.getPlatformLineSeparator());
            sb.append(this.getProgramExecutionAsString());
        }
        return sb.toString();
    }

    public String getProgramExecutionAsString() {
        if (this.mProgramExecutionAsString == null) {
            this.mProgramExecutionAsString = this.mTranslatorSequence.translateProgramExecution(this.mProgramExecution).toString();
        }
        return this.mProgramExecutionAsString;
    }

    public List<ILocation> getFailurePath() {
        return this.mFailurePath;
    }

    public IProgramExecution<TE, E> getProgramExecution() {
        return this.mProgramExecution;
    }

    public String getReasons() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Reason: ");
        int i = 0;
        while (i < this.mUnprovabilityReasons.size()) {
            sb.append(this.mUnprovabilityReasons.get(i));
            if (i == this.mUnprovabilityReasons.size() - 1) {
                sb.append(". ");
            } else {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }
}

