/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.ITimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;

public class UserSpecifiedLimitReachedResultAtElement<ELEM extends IElement>
extends AbstractResultAtElement<ELEM>
implements ITimeoutResult {
    private final String mLongDescription;
    private final String mLimit;
    private final String mProgramExecutionAsString;

    public UserSpecifiedLimitReachedResultAtElement(String limit, ELEM element, String plugin, IBacktranslationService translatorSequence, IProgramExecution<?, ?> programExecution, String longDescription) {
        super(element, plugin, translatorSequence);
        this.mLongDescription = longDescription;
        this.mLimit = limit;
        this.mProgramExecutionAsString = programExecution != null ? translatorSequence.translateProgramExecution(programExecution).toString() : null;
    }

    public String getShortDescription() {
        return String.valueOf(this.mLimit) + " (" + this.mPlugin + ")";
    }

    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mLongDescription);
        if (this.mProgramExecutionAsString != null) {
            sb.append(CoreUtil.getPlatformLineSeparator());
            sb.append("Limit reached while looking at the following path:");
            sb.append(CoreUtil.getPlatformLineSeparator());
            sb.append(this.mProgramExecutionAsString);
        }
        return sb.toString();
    }
}

