/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.toolchain;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.PluginType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.SubchainType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ToolchainFileValidator;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public class ToolchainData
implements IToolchainData<RunDefinition> {
    private final RunDefinition mToolchain;
    private final IToolchainStorage mStorage;
    private final IUltimateServiceProvider mServices;

    public ToolchainData(IUltimateServiceProvider services, IToolchainStorage storage) {
        this(new ToolchainFileValidator().createEmptyToolchain(), services, storage);
    }

    public ToolchainData(String xmlfile, IUltimateServiceProvider services, IToolchainStorage storage) throws JAXBException, FileNotFoundException, SAXException {
        this(new ToolchainFileValidator().loadValidatedToolchain(xmlfile), services, storage);
    }

    private ToolchainData(RunDefinition toolchain, IUltimateServiceProvider services, IToolchainStorage storage) {
        this.mToolchain = toolchain;
        this.mServices = services;
        this.mStorage = storage;
    }

    public void addPlugin(PluginType plugin) {
        this.mToolchain.getToolchain().getPluginOrSubchain().add(plugin);
    }

    public void addPlugin(String name) {
        PluginType foo = new PluginType();
        foo.setId(name);
        this.mToolchain.getToolchain().getPluginOrSubchain().add(foo);
    }

    public void addSubchain(SubchainType subchain) {
        this.mToolchain.getToolchain().getPluginOrSubchain().add(subchain);
    }

    public void addToolchain(ToolchainData tc) {
        this.mToolchain.getToolchain().getPluginOrSubchain().addAll(tc.getRootElement().getToolchain().getPluginOrSubchain());
    }

    public RunDefinition getRootElement() {
        return this.mToolchain;
    }

    public IToolchainStorage getStorage() {
        return this.mStorage;
    }

    public IUltimateServiceProvider getServices() {
        return this.mServices;
    }

    public IToolchainData<RunDefinition> replaceServices(IUltimateServiceProvider newServices) {
        return new ToolchainData(this.mToolchain, newServices, this.mStorage);
    }
}

