/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.toolchain;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ObjectFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ToolchainListType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ToolchainFileValidator {
    private static final String TOOLCHAIN_PACKAGE = "de.uni_freiburg.informatik.ultimate.core.lib.toolchain";
    private static final String TOOLCHAIN_URI = "/de/uni_freiburg/informatik/ultimate/core/lib/toolchain/toolchain.xsd";

    public RunDefinition createEmptyToolchain() {
        ObjectFactory objFac = new ObjectFactory();
        RunDefinition rtr = objFac.createRunDefinition();
        rtr.setName("Unknown");
        rtr.setToolchain(objFac.createToolchainListType());
        return rtr;
    }

    public RunDefinition loadValidatedToolchain(String xmlfile) throws JAXBException, FileNotFoundException, SAXException {
        JAXBContext jc = ToolchainFileValidator.createJAXBContext();
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        URL fullPathString = this.getClass().getResource(TOOLCHAIN_URI);
        unmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(fullPathString));
        JAXBElement doc = (JAXBElement)unmarshaller.unmarshal((InputStream)new FileInputStream(xmlfile));
        return (RunDefinition)doc.getValue();
    }

    public void saveToolchain(String xmlfile, String toolchainName, ToolchainListType toolchainInstance) throws JAXBException, FileNotFoundException {
        if (toolchainName == null) {
            throw new IllegalArgumentException();
        }
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBContext jc = ToolchainFileValidator.createJAXBContext();
        RunDefinition rundef = objectFactory.createRunDefinition();
        rundef.setToolchain(toolchainInstance);
        rundef.setName(toolchainName);
        JAXBElement<RunDefinition> newdoc = objectFactory.createRundefinition(rundef);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.marshal(newdoc, (OutputStream)new FileOutputStream(xmlfile));
    }

    private static JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)TOOLCHAIN_PACKAGE, (ClassLoader)ObjectFactory.class.getClassLoader());
    }
}

