/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.translation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.Multigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.BacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DefaultTranslator<STE, TTE, SE, TE, SVL, TVL>
implements ITranslator<STE, TTE, SE, TE, SVL, TVL> {
    private final Class<? extends STE> mSourceTraceElementType;
    private final Class<? extends TTE> mTargetTraceElementType;
    private final Class<SE> mSourceExpressionType;
    private final Class<TE> mTargetExpressionType;

    public DefaultTranslator(Class<? extends STE> sourceTraceElementType, Class<? extends TTE> targetTraceElementType, Class<SE> sourceExpressionType, Class<TE> targetExpressionType) {
        this.mSourceTraceElementType = sourceTraceElementType;
        this.mTargetTraceElementType = targetTraceElementType;
        this.mSourceExpressionType = sourceExpressionType;
        this.mTargetExpressionType = targetExpressionType;
        assert (this.mTargetExpressionType != null);
        assert (this.mTargetTraceElementType != null);
        assert (this.mSourceExpressionType != null);
        assert (this.mSourceTraceElementType != null);
    }

    public Class<? extends STE> getSourceTraceElementClass() {
        return this.mSourceTraceElementType;
    }

    public Class<? extends TTE> getTargetTraceElementClass() {
        return this.mTargetTraceElementType;
    }

    public Class<SE> getSourceExpressionClass() {
        return this.mSourceExpressionType;
    }

    public Class<TE> getTargetExpressionClass() {
        return this.mTargetExpressionType;
    }

    public List<TTE> translateTrace(List<STE> trace) {
        List<STE> result = null;
        try {
            result = trace;
            assert (this.consistsOfTargetTraceElements(trace));
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"Type of source trace element and type of target trace element are different. DefaultTranslator can only be applied to traces of same type.");
        }
        return result;
    }

    public List<String> targetTraceToString(List<TTE> trace) {
        ArrayList<String> rtr = new ArrayList<String>();
        for (TTE elem : trace) {
            rtr.add(elem.toString());
        }
        return rtr;
    }

    public TE translateExpression(SE expression) {
        SE result;
        try {
            result = expression;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"Type of SourceExpression and type of TargetExpression are different. DefaultTranslator can only be applied to expression of same type.");
        }
        return (TE)result;
    }

    public String targetExpressionToString(TE expression) {
        if (expression == null) {
            return "NULL";
        }
        return expression.toString();
    }

    public IProgramExecution<TTE, TE> translateProgramExecution(IProgramExecution<STE, SE> programExecution) {
        try {
            IProgramExecution<STE, SE> result = programExecution;
            assert (this.consistsOfTargetTraceElements(programExecution));
            return result;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"Type of source trace element and type of target trace element are different. DefaultTranslator can only be applied to traces of same type.");
        }
    }

    public IBacktranslatedCFG<TVL, TTE> translateCFG(IBacktranslatedCFG<SVL, STE> cfg) {
        try {
            return cfg;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"Type of source trace element and type of target trace element are different. DefaultTranslator can only be applied to the same type.");
        }
    }

    private boolean consistsOfTargetTraceElements(IProgramExecution<STE, SE> programExecution) {
        ArrayList<AtomicTraceElement> auxilliaryList = new ArrayList<AtomicTraceElement>(programExecution.getLength());
        int i = 0;
        while (i < programExecution.getLength()) {
            auxilliaryList.add(programExecution.getTraceElement(i));
            ++i;
        }
        return true;
    }

    private boolean consistsOfTargetTraceElements(List<STE> trace) {
        ArrayList<STE> auxilliaryList = new ArrayList<STE>(trace.size());
        for (STE ste : trace) {
            try {
                auxilliaryList.add(ste);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return true;
    }

    public static <STE, TTE, SE, TE, SVL, TVL> TE translateExpressionIteratively(SE expr, ITranslator<?, ?, ?, ?, ?, ?> ... iTranslators) {
        Object result;
        if (iTranslators.length == 0) {
            result = expr;
        } else {
            ITranslator<?, ?, ?, ?, ?, ?> last = iTranslators[iTranslators.length - 1];
            ITranslator<?, ?, ?, ?, ?, ?>[] allButLast = Arrays.copyOf(iTranslators, iTranslators.length - 1);
            Object expressionOfIntermediateType = last.translateExpression(expr);
            result = DefaultTranslator.translateExpressionIteratively(expressionOfIntermediateType, allButLast);
        }
        return (TE)result;
    }

    public static <STE, TTE, SE, TE, SVL, TVL> List<TTE> translateTraceIteratively(List<STE> trace, ITranslator<?, ?, ?, ?, ?, ?> ... iTranslators) {
        List<Object> result;
        if (iTranslators.length == 0) {
            result = trace;
        } else {
            ITranslator<?, ?, ?, ?, ?, ?>[] allButLast = Arrays.copyOf(iTranslators, iTranslators.length - 1);
            result = DefaultTranslator.translateTraceIteratively(trace, allButLast);
        }
        return result;
    }

    public static <STE, TTE, SE, TE, SVL, TVL> IProgramExecution<TTE, TE> translateProgramExecutionIteratively(IProgramExecution<STE, SE> programExecution, ITranslator<?, ?, ?, ?, ?, ?> ... iTranslators) {
        Object result;
        if (iTranslators.length == 0) {
            result = programExecution;
        } else {
            ITranslator<?, ?, ?, ?, ?, ?> last = iTranslators[iTranslators.length - 1];
            ITranslator<?, ?, ?, ?, ?, ?>[] allButLast = Arrays.copyOf(iTranslators, iTranslators.length - 1);
            IProgramExecution peOfIntermediateType = last.translateProgramExecution(programExecution);
            result = DefaultTranslator.translateProgramExecutionIteratively(peOfIntermediateType, allButLast);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" SE=");
        sb.append(this.getSourceExpressionClass().getName());
        sb.append(" TE=");
        sb.append(this.getTargetExpressionClass().getName());
        sb.append(" STE=");
        sb.append(this.getSourceTraceElementClass().getName());
        sb.append(" TTE=");
        sb.append(this.getTargetTraceElementClass().getName());
        return sb.toString();
    }

    protected IBacktranslatedCFG<TVL, TTE> translateCFG(IBacktranslatedCFG<SVL, STE> cfg, IFunction<Map<IExplicitEdgesMultigraph<?, ?, SVL, ? extends STE, ?>, Multigraph<TVL, TTE>>, IMultigraphEdge<?, ?, SVL, STE, ?>, Multigraph<TVL, TTE>, Multigraph<TVL, TTE>> funTranslateEdge, IFunction<String, List<Multigraph<TVL, TTE>>, Class<? extends TTE>, IBacktranslatedCFG<TVL, TTE>> funCreateBCFG) {
        List oldRoots = cfg.getCFGs();
        ArrayList newRoots = new ArrayList();
        for (IExplicitEdgesMultigraph oldRoot : oldRoots) {
            Multigraph newRoot = this.createUnlabeledWitnessNode((IElement)oldRoot);
            HashMap nodeCache = new HashMap();
            ArrayDeque<Pair> worklist = new ArrayDeque<Pair>();
            HashSet<IExplicitEdgesMultigraph> closed = new HashSet<IExplicitEdgesMultigraph>();
            newRoots.add(newRoot);
            nodeCache.put(oldRoot, newRoot);
            worklist.add(new Pair((Object)oldRoot, newRoot));
            while (!worklist.isEmpty()) {
                Pair current = (Pair)worklist.remove();
                IExplicitEdgesMultigraph oldSourceNode = (IExplicitEdgesMultigraph)current.getFirst();
                Multigraph newSourceNode = (Multigraph)current.getSecond();
                if (!closed.add(oldSourceNode)) continue;
                for (IMultigraphEdge edge : oldSourceNode.getOutgoingEdges()) {
                    Multigraph<TVL, TTE> newTargetNode = funTranslateEdge.create(nodeCache, edge, newSourceNode);
                    if (newTargetNode == null) continue;
                    worklist.add(new Pair((Object)edge.getTarget(), newTargetNode));
                }
            }
        }
        return funCreateBCFG.create(cfg.getFilename(), newRoots, this.mTargetTraceElementType);
    }

    protected IBacktranslatedCFG<TVL, TTE> translateCFG(IBacktranslatedCFG<SVL, STE> cfg, IFunction<Map<IExplicitEdgesMultigraph<?, ?, SVL, ? extends STE, ?>, Multigraph<TVL, TTE>>, IMultigraphEdge<?, ?, SVL, STE, ?>, Multigraph<TVL, TTE>, Multigraph<TVL, TTE>> funTranslateEdge) {
        return this.translateCFG(cfg, funTranslateEdge, (a, b, c) -> new BacktranslatedCFG((String)a, b, c));
    }

    protected <VL> Multigraph<VL, TTE> createLabeledWitnessNode(IExplicitEdgesMultigraph<?, ?, VL, STE, ?> old) {
        Multigraph rtr = new Multigraph(old.getLabel());
        ModelUtils.copyAnnotations(old, rtr);
        return rtr;
    }

    protected <VL> Multigraph<VL, TTE> createUnlabeledWitnessNode(IElement old) {
        Multigraph rtr = new Multigraph(null);
        ModelUtils.copyAnnotations((IElement)old, rtr);
        return rtr;
    }

    protected void printCFG(IBacktranslatedCFG<?, ?> cfg, Consumer<String> printer) {
        for (IExplicitEdgesMultigraph root : cfg.getCFGs()) {
            ArrayDeque<IExplicitEdgesMultigraph> worklist = new ArrayDeque<IExplicitEdgesMultigraph>();
            HashSet<IExplicitEdgesMultigraph> closed = new HashSet<IExplicitEdgesMultigraph>();
            worklist.add(root);
            while (!worklist.isEmpty()) {
                IExplicitEdgesMultigraph current = (IExplicitEdgesMultigraph)worklist.remove();
                if (!closed.add(current)) continue;
                printer.accept(current.toString());
                for (IMultigraphEdge out : current.getOutgoingEdges()) {
                    printer.accept("  --" + out + "--> " + out.getTarget());
                    worklist.add(out.getTarget());
                }
            }
        }
    }

    protected void printHondas(IBacktranslatedCFG<?, ?> cfg, Consumer<String> printer) {
        for (IExplicitEdgesMultigraph graph : cfg.getCFGs()) {
            Set set = this.getHondas(graph);
            if (set.isEmpty()) {
                printer.accept("No Hondas");
            }
            for (Object entry : set) {
                printer.accept("Honda: " + entry);
            }
        }
    }

    protected <VL, EL> Set<VL> getHondas(IExplicitEdgesMultigraph<?, ?, VL, EL, ?> root) {
        ArrayDeque<Object> worklist = new ArrayDeque<Object>();
        HashSet<IExplicitEdgesMultigraph> closed = new HashSet<IExplicitEdgesMultigraph>();
        HashSet<IExplicitEdgesMultigraph> hondas = new HashSet<IExplicitEdgesMultigraph>();
        worklist.add(root);
        while (!worklist.isEmpty()) {
            IExplicitEdgesMultigraph current = (IExplicitEdgesMultigraph)worklist.remove();
            if (!closed.add(current)) {
                hondas.add(current);
                continue;
            }
            for (IMultigraphEdge out : current.getOutgoingEdges()) {
                worklist.add(out.getTarget());
            }
        }
        return hondas.stream().map(a -> a.getLabel()).collect(Collectors.toSet());
    }

    protected boolean checkProcedureNames(AtomicTraceElement<STE> ate, AtomicTraceElement<TTE> newAte) {
        return Objects.equals(ate.getSucceedingProcedure(), newAte.getSucceedingProcedure()) && Objects.equals(ate.getPrecedingProcedure(), newAte.getPrecedingProcedure());
    }

    protected boolean checkCallStackSourceProgramExecution(ILogger logger, IProgramExecution<STE, SE> sourceProgramExecution) {
        ArrayList<AtomicTraceElement<STE>> rtr = new ArrayList<AtomicTraceElement<STE>>();
        sourceProgramExecution.iterator().forEachRemaining(rtr::add);
        return this.checkCallStackSource(logger, rtr);
    }

    protected boolean checkCallStackTargetProgramExecution(ILogger logger, IProgramExecution<TTE, TE> sourceProgramExecution) {
        ArrayList<AtomicTraceElement<TTE>> rtr = new ArrayList<AtomicTraceElement<TTE>>();
        sourceProgramExecution.iterator().forEachRemaining(rtr::add);
        return this.checkCallStackTarget(logger, rtr);
    }

    protected boolean checkCallStackSource(ILogger logger, List<AtomicTraceElement<STE>> trace) {
        int index = DefaultTranslator.getBrokenCallStackIndexForTrace(logger, trace);
        if (index == -1) {
            return true;
        }
        this.printBrokenCallStackSource(trace, index);
        return false;
    }

    protected boolean checkCallStackTarget(ILogger logger, List<AtomicTraceElement<TTE>> trace) {
        int index = DefaultTranslator.getBrokenCallStackIndexForTrace(logger, trace);
        if (index == -1) {
            return true;
        }
        this.printBrokenCallStackTarget(trace, index);
        return false;
    }

    private static int getBrokenCallStackIndexForTrace(ILogger logger, List<? extends AtomicTraceElement<?>> trace) {
        ArrayDeque<String> callStack = new ArrayDeque<String>();
        int i = 0;
        for (AtomicTraceElement<?> elem : trace) {
            ++i;
            if (elem.hasStepInfo(AtomicTraceElement.StepInfo.PROC_CALL)) {
                if (elem.getSucceedingProcedure() == null) {
                    logger.fatal((Object)("Callstack has procedure call flag but succeeding procedure is empty at " + elem));
                    return i;
                }
                callStack.push(elem.getSucceedingProcedure());
            }
            if (!elem.hasStepInfo(AtomicTraceElement.StepInfo.PROC_RETURN)) continue;
            if (callStack.isEmpty()) {
                logger.fatal((Object)("Callstack is empty and returning with " + elem));
                return i;
            }
            String lastCall = (String)callStack.pop();
            if (lastCall.equals(elem.getPrecedingProcedure())) continue;
            logger.fatal((Object)("Callstack is " + lastCall + " but returning with " + elem));
            return i;
        }
        return -1;
    }

    protected void printBrokenCallStackSource(List<AtomicTraceElement<STE>> trace, int breakpointIndex) {
    }

    protected void printBrokenCallStackTarget(List<AtomicTraceElement<TTE>> trace, int breakpointIndex) {
    }

    public IProgramExecution.ProgramState<TE> translateProgramState(IProgramExecution.ProgramState<SE> oldProgramState) {
        if (oldProgramState == null) {
            return null;
        }
        HashMap variable2Values = new HashMap();
        for (Object oldVariable : oldProgramState.getVariables()) {
            ArrayList<TE> newValues = new ArrayList<TE>();
            for (Object oldValue : oldProgramState.getValues(oldVariable)) {
                newValues.add(this.translateExpression(oldValue));
            }
            TE newVariable = this.translateExpression(oldVariable);
            variable2Values.put(newVariable, newValues);
        }
        return new IProgramExecution.ProgramState(variable2Values, this.getTargetExpressionClass());
    }

    @FunctionalInterface
    public static interface IFunction<P1, P2, P3, R> {
        public R create(P1 var1, P2 var2, P3 var3);
    }
}

