/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.translation;

import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ProgramExecutionFormatter<TE, E> {
    private final IBacktranslationValueProvider<TE, E> mStringProvider;

    public ProgramExecutionFormatter(IBacktranslationValueProvider<TE, E> stringProvider) {
        this.mStringProvider = stringProvider;
    }

    public String formatProgramExecution(IProgramExecution<TE, E> execution) {
        StringBuilder sb = new StringBuilder();
        String valuation = this.getValuesAsString(execution.getInitialProgramState());
        String lineSeparator = CoreUtil.getPlatformLineSeparator();
        List<String> lineNumerColumn = this.getLineNumberColumn(execution);
        int lineNumberColumnLength = ProgramExecutionFormatter.getColumnMaxLength(lineNumerColumn);
        List<String> stepInfoColum = this.getStepInfoColum(execution);
        int stepInfoColumLength = ProgramExecutionFormatter.getColumnMaxLength(stepInfoColum);
        if (stepInfoColumLength < 6) {
            stepInfoColumLength = 6;
        }
        List<String> threadIdColumn = this.getThreadIdColumn(execution);
        int threadIdColumnLength = ProgramExecutionFormatter.getColumnMaxLength(threadIdColumn);
        List<String> relevanceInfoColum = this.getRelevanceInformationColumn(execution);
        int relevanceInfoColumnLength = ProgramExecutionFormatter.getColumnMaxLength(relevanceInfoColum);
        int valOffset = stepInfoColumLength + relevanceInfoColumnLength + threadIdColumnLength;
        if (valuation != null) {
            sb.append(ProgramExecutionFormatter.fillWithChar(" ", lineNumberColumnLength));
            ProgramExecutionFormatter.addFixedLength(sb, "IVAL", valOffset, " ");
            sb.append(valuation);
            sb.append(lineSeparator);
        }
        int i = 0;
        while (i < execution.getLength()) {
            ProgramExecutionFormatter.addFixedLength(sb, lineNumerColumn, i, lineNumberColumnLength, " ");
            ProgramExecutionFormatter.addFixedLength(sb, stepInfoColum, i, stepInfoColumLength, " ");
            ProgramExecutionFormatter.addFixedLength(sb, relevanceInfoColum, i, relevanceInfoColumnLength, " ");
            ProgramExecutionFormatter.addFixedLength(sb, threadIdColumn, i, threadIdColumnLength, " ");
            AtomicTraceElement currentATE = execution.getTraceElement(i);
            this.appendStepAsString(sb, currentATE, false);
            sb.append(lineSeparator);
            valuation = this.getValuesAsString(execution.getProgramState(i));
            if (valuation != null) {
                sb.append(ProgramExecutionFormatter.fillWithChar(" ", lineNumberColumnLength));
                ProgramExecutionFormatter.addFixedLength(sb, "VAL", valOffset, " ");
                sb.append(valuation);
                sb.append(lineSeparator);
            }
            ++i;
        }
        return sb.toString();
    }

    private void appendStepAsString(StringBuilder sb, AtomicTraceElement<TE> currentATE, boolean witness) {
        boolean witnessMode;
        Object currentStep = currentATE.getStep();
        String str = this.mStringProvider.getStringFromStep(currentStep);
        boolean bl = witnessMode = witness && (currentATE.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE) || currentATE.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE));
        if (witnessMode) {
            sb.append("[");
        }
        if (currentATE.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE)) {
            sb.append("!(");
            sb.append(str);
            sb.append(")");
        } else {
            sb.append(str);
        }
        if (witnessMode) {
            sb.append("]");
        }
    }

    private String getValuesAsString(IProgramExecution.ProgramState<E> programState) {
        if (programState == null) {
            return null;
        }
        ArrayList keys = new ArrayList(programState.getVariables());
        if (keys.isEmpty()) {
            return null;
        }
        Collections.sort(keys, (arg0, arg1) -> this.mStringProvider.getStringFromExpression(arg0).compareToIgnoreCase(this.mStringProvider.getStringFromExpression(arg1)));
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        for (Object variable : keys) {
            ++i;
            String varName = this.mStringProvider.getStringFromExpression(variable);
            Collection values = programState.getValues(variable);
            for (Object value : values) {
                sb.append(varName);
                sb.append("=");
                sb.append(this.mStringProvider.getStringFromExpression(value));
                if (i >= keys.size()) continue;
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private static void addFixedLength(StringBuilder sb, String actualString, int fillLength, String fillChar) {
        sb.append(actualString);
        sb.append(ProgramExecutionFormatter.fillWithChar(fillChar, fillLength - actualString.length()));
    }

    private static void addFixedLength(StringBuilder sb, List<String> column, int index, int fillLength, String fillChar) {
        if (column == null) {
            return;
        }
        ProgramExecutionFormatter.addFixedLength(sb, column.get(index), fillLength, fillChar);
    }

    private static String fillWithChar(String string, int length) {
        if (length <= 0) {
            return "";
        }
        StringBuilder outputBuffer = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            outputBuffer.append(string);
            ++i;
        }
        return outputBuffer.toString();
    }

    private static int getColumnMaxLength(List<String> column) {
        if (column == null) {
            return 0;
        }
        return ProgramExecutionFormatter.getMaxLength(column) + 2;
    }

    private static int getMaxLength(List<String> lineNumerColumn) {
        int max = 0;
        for (String s : lineNumerColumn) {
            int length = s.length();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    private List<String> getThreadIdColumn(IProgramExecution<TE, E> execution) {
        if (!execution.isConcurrent()) {
            return null;
        }
        ArrayList<String> rtr = new ArrayList<String>();
        int i = 0;
        while (i < execution.getLength()) {
            AtomicTraceElement elem = execution.getTraceElement(i);
            rtr.add(String.valueOf(elem.getThreadId()));
            ++i;
        }
        return rtr;
    }

    private List<String> getStepInfoColum(IProgramExecution<TE, E> execution) {
        ArrayList<String> rtr = new ArrayList<String>();
        int i = 0;
        while (i < execution.getLength()) {
            AtomicTraceElement elem = execution.getTraceElement(i);
            if (elem.hasStepInfo(AtomicTraceElement.StepInfo.NONE)) {
                rtr.add("");
            } else {
                String str = elem.getStepInfo().toString();
                rtr.add(str.substring(1, str.length() - 1));
            }
            ++i;
        }
        return rtr;
    }

    private List<String> getLineNumberColumn(IProgramExecution<TE, E> execution) {
        ArrayList<String> rtr = new ArrayList<String>();
        int i = 0;
        while (i < execution.getLength()) {
            AtomicTraceElement elem = execution.getTraceElement(i);
            StringBuilder sb = new StringBuilder();
            int start = this.mStringProvider.getStartLineNumberFromStep(elem.getStep());
            int end = this.mStringProvider.getEndLineNumberFromStep(elem.getStep());
            if (start < 0) {
                sb.append("[?]");
            } else {
                sb.append("[L");
                if (start == end) {
                    sb.append(start);
                } else {
                    sb.append(start);
                    sb.append("-L");
                    sb.append(end);
                }
                sb.append("]");
            }
            rtr.add(sb.toString());
            ++i;
        }
        return rtr;
    }

    private List<String> getRelevanceInformationColumn(IProgramExecution<TE, E> execution) {
        ArrayList<String> rtr = new ArrayList<String>();
        int numberOfRelevanceInformations = 0;
        int i = 0;
        while (i < execution.getLength()) {
            IRelevanceInformation ri = execution.getTraceElement(i).getRelevanceInformation();
            if (ri == null) {
                rtr.add("?");
            } else {
                rtr.add(ri.getShortString());
                ++numberOfRelevanceInformations;
            }
            ++i;
        }
        if (numberOfRelevanceInformations == 0) {
            return null;
        }
        return rtr;
    }
}

