/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.translation;

import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import java.util.List;

public class TranslatorConcatenation<STE, ITE, TTE, SE, IE, TE, SVL, IVL, TVL>
implements ITranslator<STE, TTE, SE, TE, SVL, TVL> {
    private final ITranslator<STE, ITE, SE, IE, SVL, IVL> mSource2IntermediateTranslator;
    private final ITranslator<ITE, TTE, IE, TE, IVL, TVL> mIntermediate2TargetTranslator;

    public TranslatorConcatenation(ITranslator<STE, ITE, SE, IE, SVL, IVL> source2IntermediateTranslator, ITranslator<ITE, TTE, IE, TE, IVL, TVL> intermediate2TargetTranslator) {
        this.mSource2IntermediateTranslator = source2IntermediateTranslator;
        this.mIntermediate2TargetTranslator = intermediate2TargetTranslator;
    }

    public Class<? extends STE> getSourceTraceElementClass() {
        return this.mSource2IntermediateTranslator.getSourceTraceElementClass();
    }

    public Class<? extends TTE> getTargetTraceElementClass() {
        return this.mIntermediate2TargetTranslator.getTargetTraceElementClass();
    }

    public Class<SE> getSourceExpressionClass() {
        return this.mSource2IntermediateTranslator.getSourceExpressionClass();
    }

    public Class<TE> getTargetExpressionClass() {
        return this.mIntermediate2TargetTranslator.getTargetExpressionClass();
    }

    public List<TTE> translateTrace(List<STE> trace) {
        return this.mIntermediate2TargetTranslator.translateTrace(this.mSource2IntermediateTranslator.translateTrace(trace));
    }

    public List<String> targetTraceToString(List<TTE> trace) {
        return this.mIntermediate2TargetTranslator.targetTraceToString(trace);
    }

    public TE translateExpression(SE expression) {
        return (TE)this.mIntermediate2TargetTranslator.translateExpression(this.mSource2IntermediateTranslator.translateExpression(expression));
    }

    public String targetExpressionToString(TE expression) {
        return this.mIntermediate2TargetTranslator.targetExpressionToString(expression);
    }

    public IProgramExecution<TTE, TE> translateProgramExecution(IProgramExecution<STE, SE> programExecution) {
        return this.mIntermediate2TargetTranslator.translateProgramExecution(this.mSource2IntermediateTranslator.translateProgramExecution(programExecution));
    }

    public IBacktranslatedCFG<TVL, TTE> translateCFG(IBacktranslatedCFG<SVL, STE> cfg) {
        return this.mIntermediate2TargetTranslator.translateCFG(this.mSource2IntermediateTranslator.translateCFG(cfg));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" SE=");
        sb.append(this.getSourceExpressionClass().getName());
        sb.append(" TE=");
        sb.append(this.getTargetExpressionClass().getName());
        sb.append(" STE=");
        sb.append(this.getSourceTraceElementClass().getName());
        sb.append(" TTE=");
        sb.append(this.getTargetTraceElementClass().getName());
        return sb.toString();
    }

    public IProgramExecution.ProgramState<TE> translateProgramState(IProgramExecution.ProgramState<SE> oldProgramState) {
        return this.mIntermediate2TargetTranslator.translateProgramState(this.mSource2IntermediateTranslator.translateProgramState(oldProgramState));
    }
}

