/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.util;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;

public class LoggerOutputStream
extends OutputStream {
    private final Consumer<String> mLinePrinter;
    private static final String LINE_BREAK = CoreUtil.getPlatformLineSeparator();
    private StringBuilder mLineBuffer;

    public LoggerOutputStream(Consumer<String> linePrinter) {
        this.mLinePrinter = linePrinter;
        this.mLineBuffer = new StringBuilder();
    }

    @Override
    public void write(int b) {
        this.mLineBuffer.append(new String(new byte[]{(byte)(b & 0xFF)}, Charset.defaultCharset()));
        int length = this.mLineBuffer.length();
        int lastIndex = length - LINE_BREAK.length();
        if (lastIndex <= 0) {
            return;
        }
        if (LINE_BREAK.equals(this.mLineBuffer.substring(lastIndex))) {
            this.mLineBuffer.delete(lastIndex, length);
            this.flush();
        }
    }

    @Override
    public void flush() {
        this.mLinePrinter.accept(this.mLineBuffer.toString());
        this.mLineBuffer = new StringBuilder();
    }
}

