/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.util;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class MonitoredProcess
implements IStorable,
AutoCloseable {
    private static final int WAIT_FOR_EXIT_COMMAND_MILLIS = 200;
    private static final int WAIT_BETWEEN_CHECKS_MILLIS = 50;
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final AtomicInteger sInstanceCounter = new AtomicInteger();
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final String mCommand;
    private final String mExitCommand;
    private final PipedInputStream mStdInStreamPipe;
    private final PipedInputStream mStdErrStreamPipe;
    private final AtomicBoolean mTimeoutAttached;
    private Thread mProcessRunner;
    private int mID;
    private Process mProcess;
    private volatile int mReturnCode;
    private final CompletableFuture<Process> mProcessOnExit;
    private final AtomicBoolean mIsKillProcessCalled;

    private MonitoredProcess(Process process, String command, String exitCommand, IUltimateServiceProvider services, ILogger logger) {
        this.mServices = Objects.requireNonNull(services);
        this.mLogger = Objects.requireNonNull(logger);
        this.mProcess = Objects.requireNonNull(process);
        this.mProcessOnExit = this.mProcess.onExit();
        this.mCommand = command;
        this.mExitCommand = exitCommand;
        this.mReturnCode = -1;
        this.mProcessRunner = null;
        this.mStdInStreamPipe = new PipedInputStream(2048);
        this.mStdErrStreamPipe = new PipedInputStream(2048);
        this.mTimeoutAttached = new AtomicBoolean(false);
        this.mIsKillProcessCalled = new AtomicBoolean(false);
    }

    public static MonitoredProcess exec(String[] command, String workingDir, String exitCommand, IUltimateServiceProvider services) throws IOException {
        File workingDirFile;
        if (command == null || command.length == 0) {
            throw new IllegalArgumentException("Cannot execute empty argument");
        }
        if (services == null) {
            throw new NullPointerException("services may not be null");
        }
        ILogger logger = services.getLoggingService().getLogger(MonitoredProcess.class);
        if (workingDir == null) {
            command[0] = MonitoredProcess.findExecutableBinary(command[0], logger);
            workingDirFile = null;
        } else {
            workingDirFile = new File(workingDir);
        }
        String oneLineCmd = Arrays.stream(command).reduce((a, b) -> String.valueOf(a) + " " + b).orElseThrow(AssertionError::new);
        MonitoredProcess newMonitoredProcess = new MonitoredProcess(Runtime.getRuntime().exec(command, null, workingDirFile), oneLineCmd, exitCommand, services, logger);
        newMonitoredProcess.start(workingDir, services.getStorage(), oneLineCmd);
        return newMonitoredProcess;
    }

    private static String findExecutableBinary(String command, ILogger logger) {
        String binary;
        File f = new File(command);
        if (f.exists()) {
            binary = f.getAbsolutePath();
        } else {
            f = new File(Paths.get(System.getProperty("user.dir"), command).toString());
            if (f.exists() && f.canExecute()) {
                binary = f.getAbsolutePath();
            } else {
                File absolutePath = CoreUtil.findExecutableBinaryOnPath((String)command);
                if (absolutePath == null) {
                    logger.error((Object)("Could not determine absolute path of external process, hoping that OS will resolve " + command));
                    binary = command;
                } else {
                    binary = absolutePath.getAbsolutePath();
                }
            }
        }
        logger.info((Object)("No working directory specified, using " + binary));
        return binary;
    }

    public static MonitoredProcess exec(String command, String exitCommand, IUltimateServiceProvider services) throws IOException {
        return MonitoredProcess.exec(command.split(" "), null, exitCommand, services);
    }

    private void start(String workingDir, IToolchainStorage storage, String oneLineCmd) {
        this.mID = sInstanceCounter.incrementAndGet();
        String key = MonitoredProcess.getKey(this.mID, oneLineCmd);
        IStorable old = storage.putStorable(key, (IStorable)this);
        if (old != null) {
            this.mLogger.warn((Object)("Destroyed unexpected old storable " + key));
            old.destroy();
        }
        ProcessRunner pr = new ProcessRunner(this);
        this.mProcessRunner = new Thread((Runnable)pr, String.format("MonitoredProcess %s %s", this.mID, oneLineCmd));
        this.mLogger.info("Starting monitored process %s with %s (exit command is %s, workingDir is %s)", new Object[]{this.mID, this.mCommand, this.mExitCommand, workingDir});
        this.mProcessRunner.start();
        pr.mEndOfSetup.acquireUninterruptibly();
    }

    public MonitoredProcessState waitfor() throws InterruptedException {
        if (this.mProcessRunner.getState() == Thread.State.TERMINATED) {
            return new MonitoredProcessState(false, false, this.mReturnCode);
        }
        this.mProcessRunner.join();
        if (this.mProcessRunner.getState() == Thread.State.TERMINATED) {
            return new MonitoredProcessState(false, false, this.mReturnCode);
        }
        return new MonitoredProcessState(true, false, this.mReturnCode);
    }

    public MonitoredProcessState waitfor(long millis) throws InterruptedException {
        if (this.mProcessRunner.getState() == Thread.State.TERMINATED) {
            return new MonitoredProcessState(false, false, this.mReturnCode);
        }
        this.mProcessRunner.join(millis);
        if (this.mProcessRunner.getState() == Thread.State.TERMINATED) {
            return new MonitoredProcessState(false, false, this.mReturnCode);
        }
        return new MonitoredProcessState(true, false, this.mReturnCode);
    }

    public MonitoredProcessState impatientWaitUntilTime(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("millis has to be non-negative but was " + millis);
        }
        this.mLogger.info("%s Waiting %s ms for monitored process", new Object[]{this.getLogStringPrefix(), millis});
        MonitoredProcessState mps = null;
        try {
            mps = this.waitfor(millis);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        if (mps == null || mps.isRunning()) {
            this.mLogger.warn("%s Timeout reached", new Object[]{this.getLogStringPrefix()});
            this.forceShutdown();
            try {
                this.mProcessRunner.join(200L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return new MonitoredProcessState(this.mProcessRunner.getState() != Thread.State.TERMINATED, true, this.mReturnCode);
        }
        return mps;
    }

    public MonitoredProcessState impatientWaitUntilTimeout(long gracePeriod) {
        MonitoredProcessState state;
        if (gracePeriod < 0L) {
            throw new IllegalArgumentException("gracePeriod must be non-negative");
        }
        this.mLogger.info("%s Waiting until timeout for monitored process", new Object[]{this.getLogStringPrefix()});
        IProgressMonitorService progressService = this.mServices.getProgressMonitorService();
        while (progressService != null && progressService.continueProcessing()) {
            try {
                state = this.waitfor(50L);
                if (state.isRunning()) continue;
                return state;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.mLogger.warn("%s Timeout while monitored process is still running, waiting %s ms for graceful end", new Object[]{this.getLogStringPrefix(), gracePeriod});
        try {
            state = this.waitfor(gracePeriod);
            if (!state.isRunning()) {
                return state;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.forceShutdown();
        return new MonitoredProcessState(this.mProcessRunner.getState() != Thread.State.TERMINATED, true, this.mReturnCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCountdownToTermination(long millis) {
        MonitoredProcess monitoredProcess = this;
        synchronized (monitoredProcess) {
            if (this.mTimeoutAttached.getAndSet(true)) {
                throw new ConcurrentModificationException("You tried to attach a timeout twice for the monitored process" + this.mID);
            }
            if (millis <= 0L) {
                throw new IllegalArgumentException("millis must be larger than zero");
            }
            new Thread(() -> {
                MonitoredProcessState monitoredProcessState = this.impatientWaitUntilTime(millis);
            }, "CountdownTimeout watcher for " + this.mID).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminationAfterTimeout(long gracePeriod) {
        MonitoredProcess monitoredProcess = this;
        synchronized (monitoredProcess) {
            if (this.mTimeoutAttached.getAndSet(true)) {
                throw new ConcurrentModificationException("You tried to attach a timeout twice for the monitored process" + this.mID);
            }
            if (gracePeriod < 0L) {
                throw new IllegalArgumentException("millis must be non-negative");
            }
            new Thread(() -> {
                MonitoredProcessState monitoredProcessState = this.impatientWaitUntilTimeout(gracePeriod);
            }, "TimeoutWatcher for " + this.mID).start();
        }
    }

    public void forceShutdown() {
        if (!this.isRunning()) {
            return;
        }
        if (this.mExitCommand != null) {
            OutputStream std = this.mProcess.getOutputStream();
            OutputStreamWriter stdWriter = new OutputStreamWriter(std, Charset.defaultCharset());
            try {
                stdWriter.write(this.mExitCommand);
                stdWriter.close();
            }
            catch (IOException e) {
                this.mLogger.error("%s Exception during sending of exit command %s: %s", new Object[]{this.getLogStringPrefix(), this.mExitCommand, e.getMessage()});
            }
            try {
                this.mLogger.debug("%s About to join with the monitor thread... ", new Object[]{this.getLogStringPrefix()});
                this.mProcessRunner.join(200L);
                this.mLogger.debug("%s Successfully joined", new Object[]{this.getLogStringPrefix()});
            }
            catch (InterruptedException interruptedException) {
                this.mLogger.debug("%s Interrupted during join", new Object[]{this.getLogStringPrefix()});
                Thread.currentThread().interrupt();
            }
            if (!this.isRunning()) {
                return;
            }
        }
        this.mLogger.warn("%s Forcibly destroying the process", new Object[]{this.getLogStringPrefix()});
        ArrayList<InputStream> tobeclosed = new ArrayList<InputStream>(5);
        try {
            tobeclosed.add(this.mProcess.getInputStream());
            tobeclosed.add(this.mProcess.getErrorStream());
            tobeclosed.add(this.mStdInStreamPipe);
            tobeclosed.add(this.mStdErrStreamPipe);
            this.killProcess();
        }
        catch (NullPointerException nullPointerException) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn("%s Process already dead, possible race condition", new Object[]{this.getLogStringPrefix()});
            }
        }
        catch (Exception ex) {
            this.mLogger.fatal("%s Something unexpected happened: %s%n%s", new Object[]{this.getLogStringPrefix(), ex, CoreUtil.getStackTrace((Throwable)ex)});
            throw ex;
        }
        for (InputStream stream : tobeclosed) {
            this.close(stream);
        }
        this.mLogger.debug("%s Forcibly destroyed the process", new Object[]{this.getLogStringPrefix()});
    }

    private void close(Closeable pipe) {
        try {
            pipe.close();
        }
        catch (IOException e) {
            this.mLogger.warn("%s An error occured during closing: %s", new Object[]{this.getLogStringPrefix(), e.getMessage()});
        }
    }

    public OutputStream getOutputStream() {
        return this.mProcess.getOutputStream();
    }

    public InputStream getErrorStream() {
        return this.mStdErrStreamPipe;
    }

    public InputStream getInputStream() {
        return this.mStdInStreamPipe;
    }

    public void destroy() {
        this.forceShutdown();
    }

    protected void finalize() throws Throwable {
        this.forceShutdown();
        super.finalize();
    }

    @Override
    public void close() throws Exception {
        this.forceShutdown();
    }

    private static String getKey(int processId, String command) {
        return String.valueOf(processId) + " " + command;
    }

    public boolean isRunning() {
        return !this.mProcessOnExit.isDone();
    }

    private String getLogStringPrefix() {
        return "[MP " + this.mCommand + " (" + this.mID + ")]";
    }

    private void killProcess() {
        if (this.mIsKillProcessCalled.getAndSet(true)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("%s Called by %s, but is already killed", new Object[]{this.getLogStringPrefix(), ReflectionUtil.getCallerSignature((int)3)});
            }
            return;
        }
        if (this.isRunning()) {
            try {
                this.mProcess.destroyForcibly();
                this.mProcessOnExit.get(200L, TimeUnit.MILLISECONDS);
                this.mReturnCode = this.mProcess.exitValue();
                this.mLogger.info("%s Forceful destruction successful, exit code %d", new Object[]{this.getLogStringPrefix(), this.mReturnCode});
            }
            catch (InterruptedException interruptedException) {
                this.mLogger.fatal("%s Interrupted while destroying process, abandoning it", new Object[]{this.getLogStringPrefix()});
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                this.mLogger.fatal("%s Encounted %s destroying process, abandoning process. Exception: %s", new Object[]{this.getLogStringPrefix(), e.getClass().getSimpleName(), e});
            }
            catch (TimeoutException timeoutException) {
                this.mLogger.fatal("%s Could not destroy process within %s ms, abandoning it", new Object[]{this.getLogStringPrefix(), 200});
            }
        } else {
            this.mLogger.info("%s Ended with exit code %s", new Object[]{this.getLogStringPrefix(), this.mProcess.exitValue()});
            this.mReturnCode = this.mProcess.exitValue();
        }
        this.mProcess = null;
        this.removeFromStorage();
    }

    private void removeFromStorage() {
        IStorable storable = this.mServices.getStorage().removeStorable(MonitoredProcess.getKey(this.mID, this.mCommand));
        if (storable != null && this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)(String.valueOf(this.getLogStringPrefix()) + " Removed from storage"));
        }
    }

    public String toString() {
        if (this.mExitCommand != null) {
            return String.format("MP %s (%s) with exit command %s", this.mCommand, this.mID, this.mExitCommand);
        }
        return String.format("MP %s (%s) without exit command", this.mCommand, this.mID);
    }

    public static final class MonitoredProcessState {
        private final boolean mIsRunning;
        private final int mReturnCode;
        private final boolean mIsKilled;

        private MonitoredProcessState(boolean isRunning, boolean isKilled, int returnCode) {
            this.mIsRunning = isRunning;
            this.mReturnCode = returnCode;
            this.mIsKilled = isKilled;
        }

        public boolean isRunning() {
            return this.mIsRunning;
        }

        public boolean isKilled() {
            return this.mIsKilled;
        }

        public int getReturnCode() {
            return this.mReturnCode;
        }
    }

    private final class PipePump
    implements Runnable {
        private final OutputStream mOutputStream;
        private final InputStreamReader mStreamReader;
        private final Semaphore mEndOfPumps;
        private final Semaphore mEndOfSetup;
        private final String mPumpName;

        private PipePump(OutputStream outputStream, InputStreamReader streamReader, Semaphore endOfSetup, Semaphore endOfPumps, String pumpName) {
            this.mOutputStream = outputStream;
            this.mStreamReader = streamReader;
            this.mEndOfPumps = endOfPumps;
            this.mPumpName = pumpName;
            this.mEndOfSetup = endOfSetup;
        }

        @Override
        public void run() {
            block13: {
                this.mEndOfSetup.release();
                try {
                    try {
                        int chunk = -1;
                        while ((chunk = this.mStreamReader.read()) != -1) {
                            this.mOutputStream.write(chunk);
                            this.mOutputStream.flush();
                        }
                    }
                    catch (IOException iOException) {
                        if (MonitoredProcess.this.mLogger.isWarnEnabled()) {
                            MonitoredProcess.this.mLogger.warn((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " The stream was forcibly closed: " + this.mPumpName));
                        }
                        try {
                            this.mOutputStream.flush();
                            this.mOutputStream.close();
                        }
                        catch (IOException iOException2) {
                            MonitoredProcess.this.mLogger.fatal((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " During closing of the streams " + this.mPumpName + ", an error occured"));
                        }
                        this.mEndOfPumps.release();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.mOutputStream.flush();
                        this.mOutputStream.close();
                    }
                    catch (IOException iOException) {
                        MonitoredProcess.this.mLogger.fatal((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " During closing of the streams " + this.mPumpName + ", an error occured"));
                    }
                    this.mEndOfPumps.release();
                    throw throwable;
                }
                try {
                    this.mOutputStream.flush();
                    this.mOutputStream.close();
                }
                catch (IOException iOException) {
                    MonitoredProcess.this.mLogger.fatal((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " During closing of the streams " + this.mPumpName + ", an error occured"));
                }
                this.mEndOfPumps.release();
            }
        }
    }

    private final class ProcessRunner
    implements Runnable {
        private static final int INITIAL_SEMAPHORE_COUNT = -2;
        private final Semaphore mEndOfSetup;
        private final MonitoredProcess mMonitoredProcess;

        private ProcessRunner(MonitoredProcess monitoredProcess2) {
            this.mMonitoredProcess = monitoredProcess2;
            this.mEndOfSetup = new Semaphore(-2);
        }

        @Override
        public void run() {
            Semaphore endOfPumps = new Semaphore(2);
            ILogger logger = this.mMonitoredProcess.mLogger;
            try {
                PipedOutputStream stdInBufferPipe = new PipedOutputStream(MonitoredProcess.this.mStdInStreamPipe);
                PipedOutputStream stdErrBufferPipe = new PipedOutputStream(MonitoredProcess.this.mStdErrStreamPipe);
                this.setUpStreamBuffer(this.mMonitoredProcess.mProcess.getInputStream(), stdInBufferPipe, endOfPumps, "stdIn");
                this.setUpStreamBuffer(this.mMonitoredProcess.mProcess.getErrorStream(), stdErrBufferPipe, endOfPumps, "stdErr");
            }
            catch (IOException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Failed during stream data buffering. Terminating abnormally."), (Throwable)e);
                }
                MonitoredProcess.this.killProcess();
                this.mEndOfSetup.release(3);
                return;
            }
            try {
                try {
                    this.mEndOfSetup.release();
                    logger.debug((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Finished thread setup"));
                    this.mMonitoredProcess.mReturnCode = this.mMonitoredProcess.mProcess.waitFor();
                    logger.debug((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Finished waiting for process"));
                    if (!endOfPumps.tryAcquire(2, 200L, TimeUnit.MILLISECONDS)) {
                        logger.warn((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Abandoning pump threads because process wont die"));
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Finished waiting for pump threads"));
                        this.logUnreadPipeContent();
                        logger.debug((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Finished dumping unread pipe content"));
                    }
                }
                catch (InterruptedException e) {
                    logger.error((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Pump interrupted. Terminating abnormally."), (Throwable)e);
                    Thread.currentThread().interrupt();
                    MonitoredProcess.this.killProcess();
                    logger.debug((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Exiting monitor thread"));
                }
            }
            finally {
                MonitoredProcess.this.killProcess();
                logger.debug((Object)(String.valueOf(MonitoredProcess.this.getLogStringPrefix()) + " Exiting monitor thread"));
            }
        }

        private void logUnreadPipeContent() {
            String stdout = CoreUtil.convertStreamToString((InputStream)MonitoredProcess.this.getInputStream());
            String stderr = CoreUtil.convertStreamToString((InputStream)MonitoredProcess.this.getErrorStream());
            if (stdout.isEmpty() && stderr.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(MonitoredProcess.this.getLogStringPrefix()).append(CoreUtil.getPlatformLineSeparator());
            if (!stdout.isEmpty()) {
                sb.append("Unread content of stdout:").append(CoreUtil.getPlatformLineSeparator()).append(stdout);
            }
            if (!stderr.isEmpty()) {
                if (!stdout.isEmpty()) {
                    sb.append(CoreUtil.getPlatformLineSeparator());
                }
                sb.append("Unread content of stderr:").append(CoreUtil.getPlatformLineSeparator()).append(stderr);
            }
            MonitoredProcess.this.mLogger.debug((Object)sb);
        }

        private void setUpStreamBuffer(InputStream inputStream, OutputStream outputStream, Semaphore endOfPumps, String name) {
            endOfPumps.acquireUninterruptibly();
            InputStreamReader streamReader = new InputStreamReader(inputStream, Charset.defaultCharset());
            String threadName = "MonitoredProcess " + MonitoredProcess.this.mID + " StreamBuffer " + name;
            new Thread((Runnable)new PipePump(outputStream, streamReader, this.mEndOfSetup, endOfPumps, name), threadName).start();
        }
    }
}

