/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.api;

import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.CreatorBuilder;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManagerImpl;

abstract class AbstractCreatorBuilder
implements CreatorBuilder {
    protected int selectedParallelism = 1000;
    protected int selectedTableSize = 500000;
    protected int selectedCacheSize = 10000;
    protected int selectedThreads = Runtime.getRuntime().availableProcessors();
    protected int selectedVarCount = 10;
    protected int selectedIncreaseFactor = 1;
    protected ParallelismManager parallelismManager;
    protected Builders.ParallelizationType parallelizationType = Builders.ParallelizationType.FORK_JOIN;
    protected boolean useApply = true;
    protected Builders.TableType tableType = Builders.TableType.CASArray;
    protected boolean useThreadSafeUT = true;
    protected boolean synchronizeReorderingOperations = false;

    AbstractCreatorBuilder() {
    }

    @Override
    public CreatorBuilder synchronizeReorderingOperations() {
        this.synchronizeReorderingOperations = true;
        return this;
    }

    @Override
    public CreatorBuilder disableThreadSafety() {
        this.useThreadSafeUT = false;
        return this;
    }

    @Override
    public CreatorBuilder setUseApply(boolean apply) {
        this.useApply = apply;
        return this;
    }

    @Override
    public CreatorBuilder setTableType(Builders.TableType type) {
        this.tableType = type;
        return this;
    }

    @Override
    public CreatorBuilder setParallelismManager(ParallelismManager manager) {
        this.parallelismManager = manager;
        return this;
    }

    @Override
    public CreatorBuilder setParallelism(int parallelism) {
        this.selectedParallelism = parallelism;
        return this;
    }

    @Override
    public CreatorBuilder setTableSize(int tableSize) {
        this.selectedTableSize = tableSize;
        return this;
    }

    @Override
    public CreatorBuilder setCacheSize(int cacheSize) {
        this.selectedCacheSize = cacheSize;
        return this;
    }

    @Override
    public CreatorBuilder setThreads(int threads) {
        this.selectedThreads = threads;
        return this;
    }

    @Override
    public CreatorBuilder setVarCount(int varCount) {
        this.selectedVarCount = varCount;
        return this;
    }

    @Override
    public CreatorBuilder setIncreaseFactor(int increaseFactor) {
        this.selectedIncreaseFactor = increaseFactor;
        return this;
    }

    @Override
    public CreatorBuilder setParallelizationType(Builders.ParallelizationType type) {
        this.parallelizationType = type;
        return this;
    }

    protected void initParallelismManagerIfNeeded() {
        if (!this.useThreadSafeUT || this.selectedThreads <= 1) {
            return;
        }
        if (this.parallelizationType == Builders.ParallelizationType.NONE) {
            return;
        }
        if (this.parallelismManager == null) {
            this.parallelismManager = new ParallelismManagerImpl(this.selectedThreads);
        }
    }
}

