/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.api;

import org.sosy_lab.pjbdd.api.AbstractCreatorBuilder;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.api.SynchronizedReorderingCreator;
import org.sosy_lab.pjbdd.bdd.BDDCreator;
import org.sosy_lab.pjbdd.bdd.BDDReductionRule;
import org.sosy_lab.pjbdd.bdd.BDDSat;
import org.sosy_lab.pjbdd.bdd.algorithm.ApplyBDDAlgorithm;
import org.sosy_lab.pjbdd.bdd.algorithm.CompletableFutureApplyAlgorithm;
import org.sosy_lab.pjbdd.bdd.algorithm.CompletableFutureITEAlgorithm;
import org.sosy_lab.pjbdd.bdd.algorithm.ForkJoinApplyAlgorithm;
import org.sosy_lab.pjbdd.bdd.algorithm.ForkJoinITEAlgorithm;
import org.sosy_lab.pjbdd.bdd.algorithm.FutureITEAlgorithm;
import org.sosy_lab.pjbdd.bdd.algorithm.GuavaFutureITEAlgorithm;
import org.sosy_lab.pjbdd.bdd.algorithm.ITEBDDAlgorithm;
import org.sosy_lab.pjbdd.bdd.algorithm.StreamITEAlgorithm;
import org.sosy_lab.pjbdd.core.cache.ArrayCache;
import org.sosy_lab.pjbdd.core.cache.CASArrayCache;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.cache.GuavaCache;
import org.sosy_lab.pjbdd.core.node.NodeManagerImpl;
import org.sosy_lab.pjbdd.core.uniquetable.DDCASArrayUniqueTable;
import org.sosy_lab.pjbdd.core.uniquetable.DDConcurrentWeakHashDeque;
import org.sosy_lab.pjbdd.core.uniquetable.DDConcurrentWeakHashMap;
import org.sosy_lab.pjbdd.core.uniquetable.UniqueTable;
import org.sosy_lab.pjbdd.core.uniquetable.WeakArrayUniqueTable;

public class BDDCreatorBuilder
extends AbstractCreatorBuilder {
    private final DD.Factory<DD> ddFactory;

    public BDDCreatorBuilder(DD.Factory<DD> factory) {
        this.ddFactory = factory;
    }

    @Override
    public Creator build() {
        this.initParallelismManagerIfNeeded();
        NodeManagerImpl<DD> nodeManager = new NodeManagerImpl<DD>(this.makeTable(), new BDDReductionRule());
        nodeManager.setVarCount(this.selectedVarCount);
        Cache<Integer, Cache.CacheData> cache = this.useThreadSafeUT ? new CASArrayCache() : new ArrayCache();
        GuavaCache satCache = new GuavaCache();
        cache.init(this.selectedCacheSize, this.selectedParallelism);
        cache.init(this.selectedCacheSize, this.selectedParallelism);
        satCache.init(this.selectedCacheSize, this.selectedParallelism);
        ITEBDDAlgorithm algorithm = null;
        BDDSat<DD> satAlgorithm = new BDDSat<DD>(satCache, nodeManager);
        if (this.useApply) {
            if (!this.useThreadSafeUT) {
                algorithm = new ApplyBDDAlgorithm<DD>(cache, nodeManager);
                return new BDDCreator(nodeManager, algorithm, satAlgorithm);
            }
            switch (this.parallelizationType) {
                case COMPLETABLE_FUTURE: {
                    algorithm = new CompletableFutureApplyAlgorithm<DD>(cache, nodeManager, this.parallelismManager);
                    break;
                }
                case FORK_JOIN: {
                    algorithm = new ForkJoinApplyAlgorithm<DD>(cache, nodeManager, this.parallelismManager);
                    break;
                }
                default: {
                    algorithm = new ApplyBDDAlgorithm<DD>(cache, nodeManager);
                    break;
                }
            }
        } else {
            if (!this.useThreadSafeUT) {
                algorithm = new ITEBDDAlgorithm<DD>(cache, nodeManager);
                return new BDDCreator(nodeManager, algorithm, satAlgorithm);
            }
            switch (this.parallelizationType) {
                case NONE: {
                    algorithm = new ITEBDDAlgorithm<DD>(cache, nodeManager);
                    break;
                }
                case FUTURE: {
                    algorithm = new FutureITEAlgorithm<DD>(cache, nodeManager, this.parallelismManager);
                    break;
                }
                case STREAM: {
                    algorithm = new StreamITEAlgorithm<DD>(cache, nodeManager, this.parallelismManager);
                    break;
                }
                case FORK_JOIN: {
                    algorithm = new ForkJoinITEAlgorithm<DD>(cache, nodeManager, this.parallelismManager);
                    break;
                }
                case GUAVA_FUTURE: {
                    algorithm = new GuavaFutureITEAlgorithm<DD>(cache, nodeManager, this.parallelismManager);
                    break;
                }
                case COMPLETABLE_FUTURE: {
                    algorithm = new CompletableFutureITEAlgorithm<DD>(cache, nodeManager, this.parallelismManager);
                }
            }
        }
        Creator creator = new BDDCreator(nodeManager, algorithm, satAlgorithm);
        if (this.synchronizeReorderingOperations) {
            creator = new SynchronizedReorderingCreator(creator);
        }
        return creator;
    }

    protected UniqueTable<DD> makeTable() {
        switch (this.tableType) {
            case ConcurrentHashBucket: {
                return this.useThreadSafeUT ? new DDConcurrentWeakHashDeque<DD>(this.selectedTableSize, this.selectedParallelism, this.ddFactory) : new WeakArrayUniqueTable<DD>(this.selectedIncreaseFactor, this.selectedTableSize, this.ddFactory);
            }
            case CASArray: {
                return this.useThreadSafeUT ? new DDCASArrayUniqueTable<DD>(this.selectedIncreaseFactor, this.selectedTableSize, this.ddFactory) : new WeakArrayUniqueTable<DD>(this.selectedIncreaseFactor, this.selectedTableSize, this.ddFactory);
            }
        }
        return this.useThreadSafeUT ? new DDConcurrentWeakHashMap<DD>(this.selectedTableSize, this.selectedParallelism, this.ddFactory) : new WeakArrayUniqueTable<DD>(this.selectedIncreaseFactor, this.selectedTableSize, this.ddFactory);
    }
}

