/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.api;

import java.math.BigInteger;
import org.sosy_lab.pjbdd.api.BDDCreatorBuilder;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.BDDCreator;
import org.sosy_lab.pjbdd.bdd.BDDReductionRule;
import org.sosy_lab.pjbdd.cbdd.CBDDApplyAlgorithm;
import org.sosy_lab.pjbdd.cbdd.CBDDForkJoinApplyAlgorithm;
import org.sosy_lab.pjbdd.cbdd.CBDDSat;
import org.sosy_lab.pjbdd.core.cache.CASArrayCache;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.cache.GuavaCache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.core.node.NodeManagerImpl;

public class CBDDCreatorBuilder
extends BDDCreatorBuilder {
    public CBDDCreatorBuilder(DD.Factory<DD> factory) {
        super(factory);
    }

    @Override
    public Creator build() {
        this.initParallelismManagerIfNeeded();
        NodeManagerImpl<DD> nodeManager = new NodeManagerImpl<DD>(this.makeTable(), new BDDReductionRule());
        nodeManager.setVarCount(this.selectedVarCount);
        CASArrayCache cache = new CASArrayCache();
        GuavaCache<DD, BigInteger> satCache = new GuavaCache<DD, BigInteger>();
        cache.init(this.selectedCacheSize, this.selectedParallelism);
        satCache.init(this.selectedCacheSize, this.selectedParallelism);
        CBDDSat satAlgorithm = new CBDDSat(satCache, nodeManager);
        CBDDApplyAlgorithm algorithm = this.parallelizationType == Builders.ParallelizationType.FORK_JOIN ? new CBDDForkJoinApplyAlgorithm(cache, nodeManager, this.parallelismManager) : new CBDDApplyAlgorithm((Cache<Integer, Cache.CacheData>)cache, (NodeManager<DD>)nodeManager);
        return new BDDCreator(nodeManager, algorithm, satAlgorithm);
    }
}

