/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.api;

import java.math.BigInteger;
import org.sosy_lab.pjbdd.api.AbstractCreatorBuilder;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.SynchronizedReorderingCreator;
import org.sosy_lab.pjbdd.core.cache.GuavaCache;
import org.sosy_lab.pjbdd.intBDD.CasIntUniqueTable;
import org.sosy_lab.pjbdd.intBDD.IntBDDAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntBDDNodeManager;
import org.sosy_lab.pjbdd.intBDD.IntCreator;
import org.sosy_lab.pjbdd.intBDD.IntSatAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntUniqueTableImpl;
import org.sosy_lab.pjbdd.intBDD.ParallelIntAlgorithm;
import org.sosy_lab.pjbdd.intBDD.SerialIntCreator;
import org.sosy_lab.pjbdd.intBDD.cache.CASIntNotCache;
import org.sosy_lab.pjbdd.intBDD.cache.CASIntOpCache;
import org.sosy_lab.pjbdd.intBDD.cache.CASIntQuantCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntNotCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntOpCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntQuantCache;

public class IntCreatorBuilder
extends AbstractCreatorBuilder {
    private boolean disableGc = false;

    @Override
    public Creator build() {
        Creator creator;
        this.initParallelismManagerIfNeeded();
        IntUniqueTableImpl uniqueTable = this.useThreadSafeUT ? new CasIntUniqueTable(this.selectedTableSize, this.selectedIncreaseFactor, this.disableGc) : new IntUniqueTableImpl(this.selectedTableSize, this.selectedIncreaseFactor, this.disableGc);
        IntBDDNodeManager nodeManager = new IntBDDNodeManager(uniqueTable);
        nodeManager.setVarCount(this.selectedVarCount);
        IntOpCache iteCache = this.useThreadSafeUT ? new CASIntOpCache(this.selectedCacheSize) : new IntOpCache(this.selectedCacheSize);
        IntOpCache opCache = this.useThreadSafeUT ? new CASIntOpCache(this.selectedCacheSize) : new IntOpCache(this.selectedCacheSize);
        IntOpCache composeCache = this.useThreadSafeUT ? new CASIntOpCache(this.selectedCacheSize) : new IntOpCache(this.selectedCacheSize);
        IntNotCache notCache = this.useThreadSafeUT ? new CASIntNotCache(this.selectedCacheSize) : new IntNotCache(this.selectedCacheSize);
        IntQuantCache quantCache = this.useThreadSafeUT ? new CASIntQuantCache(this.selectedCacheSize) : new IntQuantCache(this.selectedCacheSize);
        GuavaCache<Integer, BigInteger> satCountCache = new GuavaCache<Integer, BigInteger>();
        satCountCache.init(this.selectedCacheSize, this.selectedParallelism);
        IntSatAlgorithm satAlgorithm = new IntSatAlgorithm(nodeManager, satCountCache);
        SerialIntCreator serialIntCreator = creator = this.selectedThreads > 0 && this.useThreadSafeUT ? new IntCreator(new ParallelIntAlgorithm(opCache, iteCache, notCache, quantCache, composeCache, nodeManager, this.selectedThreads), satAlgorithm, nodeManager) : new SerialIntCreator(new IntBDDAlgorithm(opCache, iteCache, notCache, quantCache, composeCache, nodeManager), satAlgorithm, nodeManager);
        if (this.synchronizeReorderingOperations) {
            creator = new SynchronizedReorderingCreator(creator);
        }
        return creator;
    }

    public IntCreatorBuilder disableGC() {
        this.disableGc = true;
        return this;
    }
}

