/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.api;

import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;

public final class Statistics {
    public static DDStats of(DD dd) {
        return new DDStats(dd);
    }

    public static Creator.Stats of(Creator creator) {
        return creator.getCreatorStats();
    }

    private Statistics() {
    }

    public static class DDStats {
        private int nodeCount;
        private int edgeCount;
        private final Set<DD> visited = new HashSet<DD>();

        private DDStats(DD pDD) {
            this.computeStats(pDD);
        }

        private void computeStats(DD dd) {
            if (this.visited.contains(dd)) {
                return;
            }
            this.visited.add(dd);
            ++this.nodeCount;
            if (dd.isLeaf()) {
                return;
            }
            this.edgeCount += 2;
            this.computeStats(dd.getHigh());
            this.computeStats(dd.getLow());
        }

        public int getEdgeCount() {
            return this.edgeCount;
        }

        public int getNodeCount() {
            return this.nodeCount;
        }
    }
}

