/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.api;

import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.util.IfThenElseData;

public class SynchronizedReorderingCreator
implements Creator {
    private final Creator creator;
    protected final ReadWriteLock reorderLock;

    public SynchronizedReorderingCreator(Creator creator) {
        this.creator = creator;
        this.reorderLock = new ReentrantReadWriteLock();
    }

    @Override
    public DD makeNot(DD f) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeNot(f);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeAnd(DD f1, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeAnd(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeOr(DD f1, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeOr(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeXor(DD f1, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeXor(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeNor(DD f1, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeNor(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeXnor(DD f1, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeXnor(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeNand(DD f1, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeNand(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public DD makeEqual(DD f1, DD f2) {
        return this.makeXnor(f1, f2);
    }

    @Override
    public DD makeUnequal(DD f1, DD f2) {
        return this.makeXor(f1, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeImply(DD f1, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeImply(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public DD anySat(DD bdd) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.anySat(bdd);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public BigInteger satCount(DD b) {
        this.reorderLock.readLock().lock();
        try {
            BigInteger bigInteger = this.creator.satCount(b);
            return bigInteger;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public Creator.Stats getCreatorStats() {
        return this.creator.getCreatorStats();
    }

    @Override
    public void cleanUnusedNodes() {
        this.reorderLock.writeLock().lock();
        try {
            this.creator.cleanUnusedNodes();
        }
        finally {
            this.reorderLock.writeLock().unlock();
        }
    }

    @Override
    public IfThenElseData getIfThenElse(DD f) {
        return this.creator.getIfThenElse(f);
    }

    @Override
    public DD makeNode(DD low, DD high, int var) {
        return this.creator.makeNode(low, high, var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeExists(DD f1, DD[] f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeExists(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeExists(DD f1, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeExists(f1, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeCompose(DD f1, int var, DD f2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeCompose(f1, var, f2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeReplace(DD f1, DD oldVar, DD replaceVar) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeReplace(f1, oldVar, replaceVar);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public DD getLow(DD top) {
        return this.creator.getLow(top);
    }

    @Override
    public DD getHigh(DD top) {
        return this.creator.getHigh(top);
    }

    @Override
    public DD makeTrue() {
        return this.creator.makeTrue();
    }

    @Override
    public DD makeFalse() {
        return this.creator.makeFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD makeIte(DD f1, DD f2, DD f3) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.creator.makeIte(f1, f2, f3);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public DD makeVariable() {
        return this.creator.makeVariable();
    }

    @Override
    public DD makeVariableBefore(DD var) {
        return this.creator.makeVariableBefore(var);
    }

    @Override
    public DD restrict(DD bdd, int var, boolean restrictionVar) {
        return this.creator.makeVariable();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void setVarOrder(List<Integer> pOrder) {
        this.reorderLock.writeLock().lock();
        try {
            this.creator.setVarOrder(pOrder);
        }
        finally {
            this.reorderLock.writeLock().unlock();
        }
    }

    @Override
    public int getVariableCount() {
        return this.creator.getVariableCount();
    }

    @Override
    public int[] getVariableOrdering() {
        return this.creator.getVariableOrdering();
    }

    @Override
    public void setVariableCount(int count) {
        this.reorderLock.readLock().lock();
        try {
            this.creator.setVariableCount(count);
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public void shutDown() {
        this.creator.shutDown();
    }
}

