/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.api;

import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.api.ZDDCreator;
import org.sosy_lab.pjbdd.core.cache.CASArrayCache;
import org.sosy_lab.pjbdd.core.cache.GuavaCache;
import org.sosy_lab.pjbdd.core.node.NodeManagerImpl;
import org.sosy_lab.pjbdd.core.uniquetable.DDCASArrayUniqueTable;
import org.sosy_lab.pjbdd.core.uniquetable.DDConcurrentWeakHashDeque;
import org.sosy_lab.pjbdd.core.uniquetable.UniqueTable;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManagerImpl;
import org.sosy_lab.pjbdd.zdd.ZDDConcurrentAlgorithm;
import org.sosy_lab.pjbdd.zdd.ZDDCreatorImpl;
import org.sosy_lab.pjbdd.zdd.ZDDReductionRule;
import org.sosy_lab.pjbdd.zdd.ZDDSat;
import org.sosy_lab.pjbdd.zdd.ZDDSerialAlgorithm;

public class ZDDBuilder {
    private final DD.Factory<DD> factory;
    protected int selectedParallelism = 1000;
    protected int selectedTableSize = 500000;
    protected int selectedCacheSize = 10000;
    protected int selectedThreads = Runtime.getRuntime().availableProcessors();
    protected int selectedVarCount = 10;
    protected int selectedIncreaseFactor = 1;
    protected ParallelismManager parallelismManager = new ParallelismManagerImpl();
    protected Builders.TableType tableType = Builders.TableType.CASArray;

    public ZDDBuilder(DD.Factory<DD> factory) {
        this.factory = factory;
    }

    public ZDDBuilder setSelectedParallelism(int parallelism) {
        this.selectedParallelism = parallelism;
        return this;
    }

    public ZDDBuilder setSelectedCacheSize(int cacheSize) {
        this.selectedCacheSize = cacheSize;
        return this;
    }

    public ZDDBuilder setTableType(Builders.TableType type) {
        this.tableType = type;
        return this;
    }

    public ZDDBuilder setParallelismManager(ParallelismManager manager) {
        this.parallelismManager = manager;
        return this;
    }

    public ZDDBuilder setParallelism(int parallelism) {
        this.selectedParallelism = parallelism;
        return this;
    }

    public ZDDBuilder setTableSize(int tableSize) {
        this.selectedTableSize = tableSize;
        return this;
    }

    public ZDDBuilder setCacheSize(int cacheSize) {
        this.selectedCacheSize = cacheSize;
        return this;
    }

    public ZDDBuilder setThreads(int threads) {
        if (threads != this.selectedThreads) {
            this.parallelismManager = new ParallelismManagerImpl(threads);
        }
        this.selectedThreads = threads;
        return this;
    }

    public ZDDBuilder setVarCount(int varCount) {
        this.selectedVarCount = varCount;
        return this;
    }

    public ZDDBuilder setIncreaseFactor(int increaseFactor) {
        this.selectedIncreaseFactor = increaseFactor;
        return this;
    }

    public ZDDCreator build() {
        NodeManagerImpl<DD> nodeManager = new NodeManagerImpl<DD>(this.makeTable(), new ZDDReductionRule());
        nodeManager.setVarCount(this.selectedVarCount);
        CASArrayCache cache = new CASArrayCache();
        cache.init(this.selectedCacheSize, this.selectedParallelism);
        ZDDSerialAlgorithm algorithm = this.selectedThreads > 1 ? new ZDDConcurrentAlgorithm<DD>(cache, nodeManager, this.parallelismManager) : new ZDDSerialAlgorithm<DD>(cache, nodeManager);
        GuavaCache satCountCache = new GuavaCache();
        satCountCache.init(this.selectedCacheSize, this.selectedParallelism);
        return new ZDDCreatorImpl(new ZDDSat<DD>(satCountCache, nodeManager), nodeManager, algorithm);
    }

    protected UniqueTable<DD> makeTable() {
        if (this.tableType == Builders.TableType.ConcurrentHashBucket) {
            return new DDConcurrentWeakHashDeque<DD>(this.selectedTableSize, this.selectedParallelism, this.factory);
        }
        return new DDCASArrayUniqueTable<DD>(this.selectedIncreaseFactor, this.selectedTableSize, this.factory);
    }
}

