/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd;

import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.algorithm.DDAlgorithm;
import org.sosy_lab.pjbdd.core.algorithm.ManipulatingAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;
import org.sosy_lab.pjbdd.util.IntArrayUtils;

public abstract class AbstractBDDAlgorithm<V extends DD>
extends ManipulatingAlgorithm<V>
implements DDAlgorithm<V> {
    protected Cache<Integer, Cache.CacheData> quantCache;
    protected Cache<Integer, Cache.CacheData> composeCache;

    public AbstractBDDAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager) {
        super(computedTable, nodeManager);
        this.quantCache = computedTable.cleanCopy();
        this.composeCache = computedTable.cleanCopy();
    }

    public V makeExist(V f, int level) {
        if (f.isLeaf() || this.level(f) > level) {
            return f;
        }
        int hash = HashCodeGenerator.generateHashCode(f.hashCode(), level);
        Cache.CacheDataExQuant data = (Cache.CacheDataExQuant)this.quantCache.get(hash);
        if (data != null && data.getF().equals(f) && data.getLevel() == level) {
            return data.getRes();
        }
        V res = null;
        if (this.level(f) == level) {
            res = this.makeOp(this.nodeManager.getHigh(f), this.nodeManager.getLow(f), DDAlgorithm.ApplyOp.OP_OR);
        }
        if (res == null) {
            V high = this.makeExist(this.nodeManager.getHigh(f), level);
            V low = this.makeExist(this.nodeManager.getLow(f), level);
            res = this.makeNode(low, high, f.getVariable());
        }
        Cache.CacheDataExQuant<V> d = new Cache.CacheDataExQuant<V>();
        d.setF(f);
        d.setLevel(level);
        d.setRes(res);
        this.quantCache.put(hash, d);
        return res;
    }

    @Override
    public V makeExists(V f, int ... levels) {
        if (f.isLeaf() || this.level(f) > levels[0] && levels.length == 1) {
            return f;
        }
        int hash = HashCodeGenerator.generateHashCode(f.hashCode(), levels[0]);
        Cache.CacheDataExQuantVararg data = (Cache.CacheDataExQuantVararg)this.quantCache.get(hash);
        Object res = null;
        if (data != null && data.matches(f, levels)) {
            res = data.getRes();
        }
        if (res == null) {
            int[] newTail;
            V fLow = this.nodeManager.getLow(f);
            V fHigh = this.nodeManager.getHigh(f);
            int fLevel = this.level(f);
            if (fLevel > levels[0]) {
                newTail = IntArrayUtils.subArray(levels, 1, levels.length);
                res = this.makeExists(f, newTail);
            } else if (fLevel == levels[0]) {
                if (levels.length == 1) {
                    res = this.makeOp(fHigh, fLow, DDAlgorithm.ApplyOp.OP_OR);
                } else {
                    newTail = IntArrayUtils.subArray(levels, 1, levels.length);
                    res = this.makeOp(this.makeExists(fLow, newTail), this.makeExists(fHigh, newTail), DDAlgorithm.ApplyOp.OP_OR);
                }
            } else {
                V high = this.makeExists(fHigh, levels);
                V low = this.makeExists(fLow, levels);
                res = this.makeNode(low, high, f.getVariable());
            }
            Cache.CacheDataExQuantVararg<V> d = new Cache.CacheDataExQuantVararg<V>();
            d.setF(f);
            d.setLevels(levels);
            d.setRes(res);
            this.quantCache.put(hash, d);
        }
        return res;
    }

    @Override
    public V makeCompose(V f1, int var, V f2) {
        V res;
        if (this.level(f1) > this.nodeManager.level(var)) {
            return f1;
        }
        int hash = HashCodeGenerator.generateHashCode(f1.hashCode(), var, f2.hashCode());
        Cache.CacheDataBinaryOp<V> data = (Cache.CacheDataBinaryOp<V>)this.composeCache.get(hash);
        if (data != null && data.matches(f1, f2, var)) {
            return data.getRes();
        }
        V f1Low = this.nodeManager.getLow(f1);
        V f1High = this.nodeManager.getHigh(f1);
        if (f1.getVariable() == var) {
            res = this.makeIte(f2, f1High, f1Low);
        } else {
            V i = this.makeCompose(f1High, var, f2);
            V e = this.makeCompose(f1Low, var, f2);
            res = this.makeIte(this.nodeManager.makeIthVar(f1.getVariable()), i, e);
        }
        data = new Cache.CacheDataBinaryOp<V>();
        data.setRes(res);
        data.setOp(var);
        data.setF1(f1);
        data.setF2(f2);
        this.composeCache.put(hash, data);
        return res;
    }
}

