/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd;

import java.math.BigInteger;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.sosy_lab.pjbdd.api.AbstractCreator;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.algorithm.DDAlgorithm;
import org.sosy_lab.pjbdd.core.algorithm.SatAlgorithm;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.BDDCreatorSimpleStats;
import org.sosy_lab.pjbdd.util.IfThenElseData;
import org.sosy_lab.pjbdd.util.IntArrayUtils;

public class BDDCreator
extends AbstractCreator
implements Creator {
    protected DDAlgorithm<DD> algorithm;
    @Nullable
    protected Creator.Stats stats;

    public BDDCreator(NodeManager<DD> nodeManager, DDAlgorithm<DD> algorithm, SatAlgorithm<DD> satAlgorithm) {
        super(nodeManager, satAlgorithm);
        this.algorithm = algorithm;
    }

    @Override
    public DD makeNot(DD f) {
        return this.algorithm.makeNot(f);
    }

    @Override
    public DD makeAnd(DD f1, DD f2) {
        return this.makeOp(f1, f2, DDAlgorithm.ApplyOp.OP_AND);
    }

    @Override
    public DD makeOr(DD f1, DD f2) {
        return this.makeOp(f1, f2, DDAlgorithm.ApplyOp.OP_OR);
    }

    @Override
    public DD makeXor(DD f1, DD f2) {
        return this.makeOp(f1, f2, DDAlgorithm.ApplyOp.OP_XOR);
    }

    @Override
    public DD makeNor(DD f1, DD f2) {
        return this.makeOp(f1, f2, DDAlgorithm.ApplyOp.OP_NOR);
    }

    @Override
    public DD makeXnor(DD f1, DD f2) {
        return this.makeOp(f1, f2, DDAlgorithm.ApplyOp.OP_XNOR);
    }

    @Override
    public DD makeNand(DD f1, DD f2) {
        return this.makeOp(f1, f2, DDAlgorithm.ApplyOp.OP_NAND);
    }

    @Override
    public DD makeEqual(DD f1, DD f2) {
        return this.makeXnor(f1, f2);
    }

    @Override
    public DD makeUnequal(DD f1, DD f2) {
        return this.makeXor(f1, f2);
    }

    @Override
    public DD makeImply(DD f1, DD f2) {
        return this.makeOp(f1, f2, DDAlgorithm.ApplyOp.OP_IMP);
    }

    private DD makeOp(DD f1, DD f2, DDAlgorithm.ApplyOp op) {
        return this.algorithm.makeOp(f1, f2, op);
    }

    @Override
    public DD anySat(DD bdd) {
        return this.satAlgorithm.anySat(bdd);
    }

    @Override
    public BigInteger satCount(DD b) {
        return this.satAlgorithm.satCount(b);
    }

    @Override
    public Creator.Stats getCreatorStats() {
        if (this.stats == null) {
            int uniqueTableNodeCount = this.nodeManager.getNodeCount();
            int uniqueTableSize = this.nodeManager.getUniqueTableSize();
            int variableCount = this.nodeManager.getVarCount();
            int cacheSize = this.algorithm.getCacheSize();
            int cacheNodeCount = this.algorithm.getCacheNodeCount();
            return new BDDCreatorSimpleStats(uniqueTableSize, uniqueTableNodeCount, cacheSize, cacheNodeCount, variableCount);
        }
        return this.stats;
    }

    @Override
    public void cleanUnusedNodes() {
        this.nodeManager.cleanUnusedNodes();
    }

    @Override
    public IfThenElseData getIfThenElse(DD f) {
        return new IfThenElseData(this.makeIthVar(f.getVariable()), this.getHigh(f), this.getLow(f));
    }

    @Override
    public DD makeNode(DD low, DD high, int var) {
        return this.algorithm.makeNode(low, high, var);
    }

    private int level(DD node) {
        return this.nodeManager.level(node.getVariable());
    }

    @Override
    public DD makeExists(DD f1, DD[] f2) {
        DD fTemp = f2[0];
        for (DD f : f2) {
            fTemp = this.makeOp(fTemp, f, DDAlgorithm.ApplyOp.OP_AND);
        }
        Set<Integer> varSet = this.createHighVarLevelSet(fTemp);
        return this.algorithm.makeExists(f1, IntArrayUtils.toIntArray(varSet));
    }

    @Override
    public DD makeExists(DD f1, DD f2) {
        Set<Integer> varSet = this.createHighVarLevelSet(f2);
        return this.algorithm.makeExists(f1, IntArrayUtils.toIntArray(varSet));
    }

    @Override
    public DD makeCompose(DD f1, int var, DD f2) {
        return this.algorithm.makeCompose(f1, var, f2);
    }

    @Override
    public DD makeReplace(DD f1, DD oldVar, DD replaceVar) {
        return this.makeExists(this.makeAnd(f1, this.makeXnor(oldVar, replaceVar)), oldVar);
    }

    private Set<Integer> createHighVarLevelSet(DD f) {
        TreeSet<Integer> varLevelSet = new TreeSet<Integer>();
        while (!f.isLeaf()) {
            varLevelSet.add(this.level(f));
            f = f.getHigh();
        }
        return varLevelSet;
    }

    @Override
    public DD getLow(DD top) {
        return this.nodeManager.getLow(top);
    }

    @Override
    public DD getHigh(DD top) {
        return this.nodeManager.getHigh(top);
    }

    @Override
    public DD makeTrue() {
        return this.nodeManager.getTrue();
    }

    @Override
    public DD makeFalse() {
        return this.nodeManager.getFalse();
    }

    @Override
    public DD makeIte(DD f1, DD f2, DD f3) {
        return this.algorithm.makeIte(f1, f2, f3);
    }

    @Override
    public DD makeVariable() {
        return this.makeNode(this.makeFalse(), this.makeTrue(), this.nodeManager.getVarCount());
    }

    @Override
    public DD makeVariableBefore(DD var) {
        return this.nodeManager.makeVariableBefore(var);
    }

    @Override
    public DD restrict(DD bdd, int var, boolean restrictionVar) {
        return bdd.getVariable() != var ? bdd : (restrictionVar ? this.getHigh(bdd) : this.getLow(bdd));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.algorithm.shutdown();
    }
}

