/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd;

import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;

public class BDDNode
implements DD {
    protected BDDNode low;
    protected BDDNode high;
    protected int var;
    protected int hashCode;

    protected BDDNode(BDDNode low, BDDNode high, int var) {
        this.low = low;
        this.high = high;
        this.var = var;
        this.rehash();
    }

    protected BDDNode() {
    }

    @Override
    public int getVariable() {
        return this.var;
    }

    @Override
    public BDDNode getLow() {
        if (this.isLeaf()) {
            return this;
        }
        return this.low;
    }

    @Override
    public BDDNode getHigh() {
        if (this.isLeaf()) {
            return this;
        }
        return this.high;
    }

    @Override
    public boolean isTrue() {
        return this.var == -1;
    }

    @Override
    public boolean isFalse() {
        return this.var == -2;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BDDNode)) {
            return false;
        }
        BDDNode other = (BDDNode)o;
        if (other.isTrue() && this.isTrue()) {
            return true;
        }
        if (other.isFalse() && this.isFalse()) {
            return true;
        }
        if (other.getVariable() != this.getVariable()) {
            return false;
        }
        return other.getHigh() == this.getHigh() && other.getLow() == this.getLow();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    protected void rehash() {
        this.hashCode = this.var < 0 ? Math.abs(this.var) : HashCodeGenerator.generateHashCode(this.getVariable(), this.getLow().hashCode(), this.getHigh().hashCode());
    }

    public static class Factory
    implements DD.Factory<DD> {
        private BDDNode one;
        private BDDNode zero;

        @Override
        public BDDNode createNode(int var, DD low, DD high) {
            return new BDDNode((BDDNode)low, (BDDNode)high, var);
        }

        @Override
        public BDDNode createTrue() {
            if (this.one == null) {
                this.one = new BDDNode(null, null, -1);
            }
            return this.one;
        }

        @Override
        public BDDNode createFalse() {
            if (this.zero == null) {
                this.zero = new BDDNode(null, null, -2);
            }
            return this.zero;
        }

        @Override
        public void setLow(DD low, DD node) {
            ((BDDNode)node).low = (BDDNode)low;
            ((BDDNode)node).rehash();
        }

        @Override
        public void setHigh(DD high, DD node) {
            ((BDDNode)node).high = (BDDNode)high;
            ((BDDNode)node).rehash();
        }

        @Override
        public void setVariable(int variable, DD node) {
            ((BDDNode)node).var = variable;
            ((BDDNode)node).rehash();
        }

        @Override
        public DD.ChildNodeResolver<DD> getChildNodeResolver() {
            return new DD.ChildNodeResolver<DD>(){

                @Override
                public DD getLow(DD root) {
                    return root.getLow();
                }

                @Override
                public DD getHigh(DD root) {
                    return root.getHigh();
                }

                @Override
                public BDDNode cast(Object root) {
                    return (BDDNode)root;
                }
            };
        }
    }
}

