/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd;

import java.math.BigInteger;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.algorithm.SatAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;

public class BDDSat<V extends DD>
implements SatAlgorithm<V> {
    protected final Cache<V, BigInteger> satCountCache;
    protected final NodeManager<V> nodeManager;

    public BDDSat(Cache<V, BigInteger> satCountCache, NodeManager<V> nodeManager) {
        this.satCountCache = satCountCache;
        this.nodeManager = nodeManager;
    }

    @Override
    public V anySat(V bdd) {
        if (bdd.isLeaf()) {
            return bdd;
        }
        if (bdd.getLow().isFalse()) {
            return this.nodeManager.makeNode(this.nodeManager.getFalse(), this.anySat(this.high(bdd)), bdd.getVariable());
        }
        return this.nodeManager.makeNode(this.anySat(this.low(bdd)), this.nodeManager.getFalse(), bdd.getVariable());
    }

    @Override
    public BigInteger satCount(V b) {
        return BigInteger.valueOf(2L).pow(this.level(b)).multiply(this.satCountRec(b));
    }

    protected BigInteger satCountRec(V root) {
        if (root.isFalse()) {
            return BigInteger.ZERO;
        }
        if (root.isTrue()) {
            return BigInteger.ONE;
        }
        BigInteger count = this.satCountCache.get(root);
        if (count != null) {
            return count;
        }
        BigInteger s = BigInteger.valueOf(2L).pow(this.level(this.low(root)) - this.level(root) - 1);
        BigInteger size = s.multiply(this.satCountRec(this.low(root)));
        s = BigInteger.valueOf(2L).pow(this.level(this.high(root)) - this.level(root) - 1);
        size = size.add(s.multiply(this.satCountRec(this.high(root))));
        this.satCountCache.put((BigInteger)root, size);
        return size;
    }

    protected int level(V bdd) {
        return this.nodeManager.level(bdd.getVariable());
    }

    protected V high(V bdd) {
        return this.nodeManager.getHigh(bdd);
    }

    protected V low(V bdd) {
        return this.nodeManager.getLow(bdd);
    }
}

