/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd.algorithm;

import java.util.Optional;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.algorithm.ITEBDDAlgorithm;
import org.sosy_lab.pjbdd.core.algorithm.DDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;

public class ApplyBDDAlgorithm<V extends DD>
extends ITEBDDAlgorithm<V> {
    public ApplyBDDAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager) {
        super(computedTable, nodeManager);
    }

    @Override
    public V makeNot(V f) {
        return this.makeNotRecursive(f);
    }

    private V makeNotRecursive(V f) {
        return (V)this.terminalNotCheck(f).orElseGet(() -> {
            DD bdd = this.makeNode(this.makeNotRecursive(this.getLow(f)), this.makeNotRecursive(this.getHigh(f)), f.getVariable());
            this.cacheUnaryItem(f, bdd);
            return bdd;
        });
    }

    @Override
    public V makeOp(V f1, V f2, DDAlgorithm.ApplyOp op) {
        return (V)this.terminalCheck(f1, f2, op).orElseGet(() -> {
            int topVar = this.topVar(this.level(f1), this.level(f2));
            DD low = this.makeOp(this.low(f1, topVar), this.low(f2, topVar), op);
            DD high = this.makeOp(this.high(f1, topVar), this.high(f2, topVar), op);
            DD res = this.makeNode(low, high, topVar);
            this.cacheBinaryItem(f1, f2, op.ordinal(), res);
            return res;
        });
    }

    protected Optional<V> terminalCheck(V f1, V f2, DDAlgorithm.ApplyOp op) {
        switch (op) {
            case OP_AND: {
                return this.terminalAndCheck(f1, f2);
            }
            case OP_OR: {
                return this.terminalOrCheck(f1, f2);
            }
            case OP_IMP: {
                return this.terminalImplyCheck(f1, f2);
            }
            case OP_XNOR: {
                return this.terminalXnorCheck(f1, f2);
            }
            case OP_NAND: {
                return this.terminalNandCheck(f1, f2);
            }
            case OP_NOR: {
                return this.terminalNorCheck(f1, f2);
            }
            case OP_XOR: {
                return this.terminalXorCheck(f1, f2);
            }
        }
        throw new IllegalArgumentException("No such op supported yet");
    }

    private Optional<V> terminalXorCheck(V f1, V f2) {
        if (f1.equals(f2)) {
            return Optional.of(this.makeFalse());
        }
        if (f1.isTrue()) {
            return Optional.of(this.makeNot(f2));
        }
        if (f2.isTrue()) {
            return Optional.of(this.makeNot(f1));
        }
        if (f1.isFalse()) {
            return Optional.of(f2);
        }
        if (f2.isFalse()) {
            return Optional.of(f1);
        }
        return this.checkBinaryCache(f1, f2, DDAlgorithm.ApplyOp.OP_XOR.ordinal());
    }

    private Optional<V> terminalNorCheck(V f1, V f2) {
        if (f1.isTrue() || f2.isTrue()) {
            return Optional.of(this.makeFalse());
        }
        if (f1.isFalse() || f1.equals(f2)) {
            return Optional.of(this.makeNot(f2));
        }
        if (f2.isFalse()) {
            return Optional.of(this.makeNot(f1));
        }
        return this.checkBinaryCache(f1, f2, DDAlgorithm.ApplyOp.OP_NOR.ordinal());
    }

    private Optional<V> terminalXnorCheck(V f1, V f2) {
        if (f1.equals(f2)) {
            return Optional.of(this.makeTrue());
        }
        if (f1.isFalse()) {
            return Optional.of(this.makeNot(f2));
        }
        if (f2.isFalse()) {
            return Optional.of(this.makeNot(f1));
        }
        if (f2.isTrue()) {
            return Optional.of(f1);
        }
        if (f1.isTrue()) {
            return Optional.of(f2);
        }
        return this.checkBinaryCache(f1, f2, DDAlgorithm.ApplyOp.OP_XNOR.ordinal());
    }

    private Optional<V> terminalNandCheck(V f1, V f2) {
        if (f1.isFalse() || f2.isFalse()) {
            return Optional.of(this.makeTrue());
        }
        if (f1.isTrue() && f2.isTrue()) {
            return Optional.of(this.makeFalse());
        }
        if (f1.equals(f2) || f2.isTrue()) {
            return Optional.of(this.makeNot(f1));
        }
        if (f1.isTrue()) {
            return Optional.of(this.makeNot(f2));
        }
        return this.checkBinaryCache(f1, f2, DDAlgorithm.ApplyOp.OP_NAND.ordinal());
    }

    private Optional<V> terminalAndCheck(V f1, V f2) {
        if (f1.equals(f2)) {
            return Optional.of(f1);
        }
        if (f1.isFalse() || f2.isFalse()) {
            return Optional.of(this.makeFalse());
        }
        if (f1.isTrue()) {
            return Optional.of(f2);
        }
        if (f2.isTrue()) {
            return Optional.of(f1);
        }
        return this.checkBinaryCache(f1, f2, DDAlgorithm.ApplyOp.OP_AND.ordinal());
    }

    private Optional<V> terminalOrCheck(V f1, V f2) {
        if (f1.equals(f2)) {
            return Optional.of(f1);
        }
        if (f1.isTrue() || f2.isTrue()) {
            return Optional.of(this.makeTrue());
        }
        if (f2.isFalse()) {
            return Optional.of(f1);
        }
        if (f1.isFalse()) {
            return Optional.of(f2);
        }
        return this.checkBinaryCache(f1, f2, DDAlgorithm.ApplyOp.OP_OR.ordinal());
    }

    protected Optional<V> terminalNotCheck(V f) {
        if (f.isTrue()) {
            return Optional.of(this.makeFalse());
        }
        if (f.isFalse()) {
            return Optional.of(this.makeTrue());
        }
        return this.checkNotCache(f);
    }

    private Optional<V> terminalImplyCheck(V f1, V f2) {
        if (f1.equals(f2)) {
            return Optional.of(this.makeTrue());
        }
        if (f1.isFalse() || f2.isTrue()) {
            return Optional.of(this.makeTrue());
        }
        if (f1.isTrue()) {
            return Optional.of(f2);
        }
        if (f2.isFalse()) {
            return Optional.of(this.makeNot(f1));
        }
        return this.checkBinaryCache(f1, f2, DDAlgorithm.ApplyOp.OP_IMP.ordinal());
    }

    @Override
    protected Optional<V> checkTerminalCases(V f1, V f2, V f3) {
        if (f2.equals(this.makeFalse()) && f3.equals(this.makeTrue())) {
            return Optional.of(this.makeNot(f1));
        }
        if (f2.isTrue()) {
            return Optional.of(this.makeOp(f1, f3, DDAlgorithm.ApplyOp.OP_OR));
        }
        if (f2.isFalse()) {
            return Optional.of(this.makeOp(f1, this.makeNot(f3), DDAlgorithm.ApplyOp.OP_NOR));
        }
        if (f3.isTrue()) {
            return Optional.of(this.makeOp(f1, f2, DDAlgorithm.ApplyOp.OP_AND));
        }
        if (f3.isFalse()) {
            return Optional.of(this.makeOp(f1, this.makeNot(f2), DDAlgorithm.ApplyOp.OP_NOR));
        }
        return super.checkTerminalCases(f1, f2, f3);
    }
}

