/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd.algorithm;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.algorithm.ApplyBDDAlgorithm;
import org.sosy_lab.pjbdd.core.algorithm.DDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public class CompletableFutureApplyAlgorithm<V extends DD>
extends ApplyBDDAlgorithm<V> {
    private final ParallelismManager parallelismManager;

    public CompletableFutureApplyAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager, ParallelismManager parallelismManager) {
        super(computedTable, nodeManager);
        this.parallelismManager = parallelismManager;
    }

    @Override
    public V makeOp(V f1, V f2, DDAlgorithm.ApplyOp op) {
        return (V)this.terminalCheck(f1, f2, op).orElseGet(() -> this.asyncShannonExpansion(f1, f2, op).join());
    }

    private CompletableFuture<V> asyncShannonExpansion(V f1, V f2, DDAlgorithm.ApplyOp op) {
        int topVar = this.topVar(this.level(f1), this.level(f2));
        CompletableFuture<V> lowFut = this.expandNext(this.low(f1, topVar), this.low(f2, topVar), topVar, op);
        CompletableFuture<V> highFut = this.expandNext(this.high(f1, topVar), this.high(f2, topVar), topVar, op);
        CompletionStage future = highFut.thenCombine(lowFut, (pos, neg) -> this.makeNode(neg, pos, topVar));
        ((CompletableFuture)future).thenAccept(result -> this.cacheBinaryItem(f1, f2, op.ordinal(), result));
        return future;
    }

    private CompletableFuture<V> expandNext(V f1, V f2, int topLevel, DDAlgorithm.ApplyOp op) {
        return this.terminalCheck(f1, f2, op).map(CompletableFuture::completedFuture).orElseGet(() -> {
            if (this.parallelismManager.canFork(topLevel)) {
                this.parallelismManager.taskSupplied();
                CompletionStage result = CompletableFuture.supplyAsync(() -> this.asyncShannonExpansion(f1, f2, op), this.parallelismManager.getThreadPool()).thenCompose(Function.identity());
                ((CompletableFuture)result).thenRun(this.parallelismManager::taskDone);
                return result;
            }
            return this.asyncShannonExpansion(f1, f2, op);
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.parallelismManager.shutdown();
    }
}

