/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd.algorithm;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.algorithm.ITEBDDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public class CompletableFutureITEAlgorithm<V extends DD>
extends ITEBDDAlgorithm<V> {
    private final ParallelismManager parallelismManager;

    public CompletableFutureITEAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager, ParallelismManager parallelismManager) {
        super(computedTable, nodeManager);
        this.parallelismManager = parallelismManager;
    }

    @Override
    public V makeIte(V f1, V f2, V f3) {
        return (V)((DD)this.terminalIteCheck(f1, f2, f3).map(CompletableFuture::completedFuture).orElseGet(() -> this.asyncExpand(f1, f2, f3)).join());
    }

    private CompletableFuture<V> asyncExpand(V f1, V f2, V f3) {
        int topVar = this.topVar(this.level(f1), this.level(f2), this.level(f3));
        ForkJoinPool service = this.parallelismManager.getThreadPool();
        CompletableFuture<V> lowFut = this.expandNext(this.low(f1, topVar), this.low(f2, topVar), this.low(f3, topVar), service, topVar);
        CompletableFuture<V> highFut = this.expandNext(this.high(f1, topVar), this.high(f2, topVar), this.high(f3, topVar), service, topVar);
        CompletionStage future = highFut.thenCombine(lowFut, (pos, neg) -> this.makeNode(neg, pos, topVar));
        ((CompletableFuture)future).thenAccept(result -> this.cacheItem(f1, f2, f3, result));
        return future;
    }

    private CompletableFuture<V> expandNext(V f1, V f2, V f3, ExecutorService service, int topLevel) {
        return this.terminalIteCheck(f1, f2, f3).map(CompletableFuture::completedFuture).orElseGet(() -> {
            if (this.parallelismManager.canFork(topLevel)) {
                this.parallelismManager.taskSupplied();
                CompletionStage result = CompletableFuture.supplyAsync(() -> this.asyncExpand(f1, f2, f3), service).thenCompose(Function.identity());
                ((CompletableFuture)result).thenRun(this.parallelismManager::taskDone);
                return result;
            }
            return this.asyncExpand(f1, f2, f3);
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.parallelismManager.shutdown();
    }
}

