/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd.algorithm;

import java.util.Optional;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.algorithm.ApplyBDDAlgorithm;
import org.sosy_lab.pjbdd.core.algorithm.DDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public class ForkJoinApplyAlgorithm<V extends DD>
extends ApplyBDDAlgorithm<V> {
    private final ParallelismManager parallelismManager;

    public ForkJoinApplyAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager, ParallelismManager parallelismManager) {
        super(computedTable, nodeManager);
        this.parallelismManager = parallelismManager;
    }

    @Override
    public V makeOp(V f1, V f2, DDAlgorithm.ApplyOp op) {
        return (V)this.terminalCheck(f1, f2, op).orElseGet(() -> this.asyncShannonExpansion(f1, f2, op));
    }

    private V asyncShannonExpansion(V f1, V f2, DDAlgorithm.ApplyOp op) {
        int topVar = this.topVar(this.level(f1), this.level(f2));
        DD low = null;
        DD high = null;
        V lowF1 = this.low(f1, topVar);
        V lowF2 = this.low(f2, topVar);
        V highF1 = this.high(f1, topVar);
        V highF2 = this.high(f2, topVar);
        Optional<V> lowCheck = this.terminalCheck(lowF1, lowF2, op);
        Optional<V> highCheck = this.terminalCheck(highF1, highF2, op);
        if (lowCheck.isPresent()) {
            low = (DD)lowCheck.get();
        }
        if (highCheck.isPresent()) {
            high = (DD)highCheck.get();
        }
        if (this.parallelismManager.canFork(topVar) && low == null && high == null) {
            Future lowTask = this.parallelismManager.getThreadPool().submit(() -> this.asyncShannonExpansion(lowF1, lowF2, op));
            Future highTask = this.parallelismManager.getThreadPool().submit(() -> this.asyncShannonExpansion(highF1, highF2, op));
            low = (DD)((ForkJoinTask)lowTask).join();
            high = (DD)((ForkJoinTask)highTask).join();
        } else {
            if (low == null) {
                low = this.asyncShannonExpansion(lowF1, lowF2, op);
            }
            if (high == null) {
                high = this.asyncShannonExpansion(highF1, highF2, op);
            }
        }
        DD res = this.makeNode(low, high, topVar);
        this.cacheBinaryItem(f1, f2, op.ordinal(), res);
        return (V)res;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.parallelismManager.shutdown();
    }
}

