/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd.algorithm;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.algorithm.ParallelITEAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public class FutureITEAlgorithm<V extends DD>
extends ParallelITEAlgorithm<V> {
    public FutureITEAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager, ParallelismManager parallelismManager) {
        super(computedTable, nodeManager, parallelismManager);
    }

    @Override
    protected V forkITE(V lowF1, V lowF2, V lowF3, V highF1, V highF2, V highF3, int topVar) {
        this.parallelismManager.taskSupplied();
        this.parallelismManager.taskSupplied();
        ForkJoinPool service = this.parallelismManager.getThreadPool();
        Future<DD> lowFut = service.submit(() -> this.makeIte(lowF1, lowF2, lowF3));
        Future<DD> highFut = service.submit(() -> this.makeIte(highF1, highF2, highF3));
        try {
            DD bdd = this.makeNode(lowFut.get(), highFut.get(), topVar);
            this.parallelismManager.taskDone();
            this.parallelismManager.taskDone();
            return (V)bdd;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

