/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd.algorithm;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.algorithm.ITEBDDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public class GuavaFutureITEAlgorithm<V extends DD>
extends ITEBDDAlgorithm<V> {
    private final ListeningExecutorService service;

    public GuavaFutureITEAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager, ParallelismManager parallelismManager) {
        super(computedTable, nodeManager);
        this.service = MoreExecutors.listeningDecorator((ExecutorService)parallelismManager.getThreadPool());
    }

    @Override
    public V makeIte(V f1, V f2, V f3) {
        try {
            return (V)((DD)this.asyncExpand(f1, f2, f3).get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private ListenableFuture<V> asyncExpand(V f1, V f2, V f3) {
        return this.terminalIteCheck(f1, f2, f3).map(Futures::immediateFuture).orElseGet(() -> {
            int topVar = this.topVar(this.level(f1), this.level(f2), this.level(f3));
            ListenableFuture lowFut = Futures.transformAsync((ListenableFuture)Futures.immediateFuture(null), input -> this.asyncExpand(this.low(f1, topVar), this.low(f2, topVar), this.low(f3, topVar)), (Executor)this.service);
            ListenableFuture highFut = Futures.transformAsync((ListenableFuture)Futures.immediateFuture(null), input -> this.asyncExpand(this.high(f1, topVar), this.high(f2, topVar), this.high(f3, topVar)), (Executor)this.service);
            ListenableFuture future = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{lowFut, highFut}).call(() -> this.makeNode((DD)lowFut.get(), (DD)highFut.get(), topVar), MoreExecutors.directExecutor());
            Futures.addCallback((ListenableFuture)future, result -> this.cacheItem(f1, f2, f3, result), (Executor)MoreExecutors.directExecutor());
            return future;
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.service.shutdown();
    }

    private static interface OnSuccessListener<V extends DD>
    extends FutureCallback<V> {
        default public void onFailure(Throwable t) {
        }
    }
}

