/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd.algorithm;

import java.util.Optional;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.AbstractBDDAlgorithm;
import org.sosy_lab.pjbdd.core.algorithm.DDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;

public class ITEBDDAlgorithm<V extends DD>
extends AbstractBDDAlgorithm<V> {
    public ITEBDDAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager) {
        super(computedTable, nodeManager);
    }

    @Override
    public V makeOp(V f1, V f2, DDAlgorithm.ApplyOp op) {
        switch (op) {
            case OP_OR: {
                return this.makeIte(f1, this.makeTrue(), f2);
            }
            case OP_AND: {
                return this.makeIte(f1, f2, this.makeFalse());
            }
            case OP_XOR: {
                return this.makeIte(f1, this.makeNot(f2), f2);
            }
            case OP_NOR: {
                return this.makeIte(f1, this.makeFalse(), this.makeNot(f2));
            }
            case OP_NAND: {
                return this.makeIte(f1, this.makeNot(f2), this.makeTrue());
            }
            case OP_IMP: {
                return this.makeOp(this.makeNot(f1), f2, DDAlgorithm.ApplyOp.OP_OR);
            }
            case OP_XNOR: {
                return this.makeIte(f1, f2, this.makeNot(f2));
            }
        }
        return this.makeFalse();
    }

    @Override
    public V makeNot(V f) {
        return this.makeIte(f, this.makeFalse(), this.makeTrue());
    }

    @Override
    public V makeIte(V ifBDD, V thenBDD, V elseBDD) {
        return (V)this.terminalIteCheck(ifBDD, thenBDD, elseBDD).orElseGet(() -> {
            int topVar = this.topVar(this.level(ifBDD), this.level(thenBDD), this.level(elseBDD));
            DD low = this.makeIte(this.low(ifBDD, topVar), this.low(thenBDD, topVar), this.low(elseBDD, topVar));
            DD high = this.makeIte(this.high(ifBDD, topVar), this.high(thenBDD, topVar), this.high(elseBDD, topVar));
            DD res = this.makeNode(low, high, topVar);
            this.cacheItem(ifBDD, thenBDD, elseBDD, res);
            return res;
        });
    }

    protected Optional<V> terminalIteCheck(V f1, V f2, V f3) {
        return this.checkTerminalCases(f1, f2, f3).or(() -> this.checkITECache(f1, f2, f3));
    }

    protected Optional<V> checkTerminalCases(V f1, V f2, V f3) {
        if (f1.equals(this.makeTrue())) {
            return Optional.of(f2);
        }
        if (f1.equals(this.makeFalse())) {
            return Optional.of(f3);
        }
        if (f2.equals(f3)) {
            return Optional.of(f2);
        }
        if (f2.equals(this.makeTrue()) && f3.equals(this.makeFalse())) {
            return Optional.of(f1);
        }
        return Optional.empty();
    }
}

