/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.bdd.algorithm;

import java.util.Optional;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.algorithm.ITEBDDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public abstract class ParallelITEAlgorithm<V extends DD>
extends ITEBDDAlgorithm<V> {
    protected final ParallelismManager parallelismManager;

    protected ParallelITEAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager, ParallelismManager parallelismManager) {
        super(computedTable, nodeManager);
        this.parallelismManager = parallelismManager;
    }

    @Override
    public V makeIte(V f1, V f2, V f3) {
        Object res;
        Optional<V> check = this.terminalIteCheck(f1, f2, f3);
        if (check.isPresent()) {
            return (V)((DD)check.get());
        }
        int topVar = this.topVar(this.level(f1), this.level(f2), this.level(f3));
        DD low = null;
        DD high = null;
        V lowF1 = this.low(f1, topVar);
        V lowF2 = this.low(f2, topVar);
        V lowF3 = this.low(f3, topVar);
        V highF1 = this.high(f1, topVar);
        V highF2 = this.high(f2, topVar);
        V highF3 = this.high(f3, topVar);
        Optional<V> lowCheck = this.terminalIteCheck(lowF1, lowF2, lowF3);
        Optional<V> highCheck = this.terminalIteCheck(highF1, highF2, highF3);
        if (lowCheck.isPresent()) {
            low = (DD)lowCheck.get();
        }
        if (highCheck.isPresent()) {
            high = (DD)highCheck.get();
        }
        if (this.forkCheck(low, high, topVar)) {
            res = this.forkITE(lowF1, lowF2, lowF3, highF1, highF2, highF3, topVar);
        } else {
            if (low == null) {
                low = this.makeIte(lowF1, lowF2, lowF3);
            }
            if (high == null) {
                high = this.makeIte(highF1, highF2, highF3);
            }
            res = this.makeNode(low, high, topVar);
        }
        this.cacheItem(f1, f2, f3, res);
        return res;
    }

    protected abstract V forkITE(V var1, V var2, V var3, V var4, V var5, V var6, int var7);

    private boolean forkCheck(V low, V high, int topVar) {
        return this.parallelismManager.canFork(topVar) && high == null && low == null;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.parallelismManager.shutdown();
    }
}

