/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.cbdd;

import com.google.common.base.Preconditions;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.algorithm.ApplyBDDAlgorithm;
import org.sosy_lab.pjbdd.cbdd.CDD;
import org.sosy_lab.pjbdd.core.algorithm.DDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.BitMaskIntTupleUtils;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;

public class CBDDApplyAlgorithm
extends ApplyBDDAlgorithm<DD> {
    public CBDDApplyAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<DD> nodeManager) {
        super(computedTable, nodeManager);
    }

    @Override
    public DD makeNode(DD low, DD high, int var) {
        if (!this.nodeManager.checkLvl(var)) {
            this.nodeManager.setVarCount(var + 1);
        }
        return this.makeChainNode(low, high, var, var);
    }

    @Override
    public DD makeOp(DD f1, DD f2, DDAlgorithm.ApplyOp op) {
        return this.terminalCheck(f1, f2, op).orElseGet(() -> this.makeOpElse(f1, f2, op));
    }

    private DD makeOpElse(DD f1, DD f2, DDAlgorithm.ApplyOp op) {
        int t = this.calculateTLevel(f1, f2);
        int b = this.calculateBLevel(f1, f2, t);
        DD f1Low = this.cofactorLow(f1, b);
        DD f2Low = this.cofactorLow(f2, b);
        DD f1High = this.cofactorHigh(f1, b);
        DD f2High = this.cofactorHigh(f2, b);
        DD low = this.makeOp(f1Low, f2Low, op);
        DD high = this.makeOp(f1High, f2High, op);
        DD res = this.combine(low, high, t, b);
        this.cacheBinaryItem(f1, f2, op.ordinal(), res);
        return res;
    }

    protected DD cofactorLow(DD u, int b) {
        int tF = this.level(u);
        int bF = this.chainEndlevel(u);
        if (b < tF) {
            return u;
        }
        if (b == bF) {
            return this.nodeManager.getLow(u);
        }
        if (tF <= b && b < bF) {
            return this.makeChainNode(this.nodeManager.getLow(u), this.nodeManager.getHigh(u), b + 1, bF);
        }
        throw new RuntimeException("Ran into unknown combination of Levels.");
    }

    protected DD cofactorHigh(DD u, int b) {
        int tF = this.level(u);
        if (b < tF) {
            return u;
        }
        return this.nodeManager.getHigh(u);
    }

    protected int calculateTLevel(DD f1, DD f2) {
        return this.topVar(this.level(f1), this.level(f2));
    }

    protected int calculateTLevel(DD f1, DD f2, DD f3) {
        return this.topVar(this.level(f1), this.level(f2), this.level(f3));
    }

    protected int calculateBLevel(DD f1, DD f2, int t) {
        return this.topVar(this.singleBLevel(f1, t), this.singleBLevel(f2, t));
    }

    protected int calculateBLevel(DD f1, DD f2, DD f3, int t) {
        return this.topVar(this.singleBLevel(f1, t), this.singleBLevel(f2, t), this.singleBLevel(f3, t));
    }

    protected DD combine(DD low, DD high, int t, int b) {
        DD res;
        if (low.equals(high)) {
            res = low;
        } else if (this.level(low) == b + 1 && low.getHigh().equals(high)) {
            int lowChainEndVar = this.castToChained(low).getChainEndVariable();
            res = this.makeChainNode(this.nodeManager.getLow(low), high, t, lowChainEndVar);
        } else {
            res = this.makeChainNode(low, high, t, b);
        }
        return res;
    }

    @Override
    public DD makeNot(DD f) {
        return this.makeNotRecursive(f);
    }

    protected DD makeNotRecursive(DD f) {
        return this.terminalNotCheck(f).orElseGet(() -> {
            DD bdd = this.makeChainNode(this.makeNotRecursive(this.nodeManager.getLow(f)), this.makeNotRecursive(this.nodeManager.getHigh(f)), f.getVariable(), this.castToChained(f).getChainEndVariable());
            this.cacheUnaryItem(f, bdd);
            return bdd;
        });
    }

    public DD makeChainNode(DD low, DD high, int var, int chainEndVar) {
        return this.nodeManager.makeNode(low, high, BitMaskIntTupleUtils.createTuple(var, chainEndVar));
    }

    protected int chainEndlevel(DD bdd) {
        return this.nodeManager.level(this.castToChained(bdd).getChainEndVariable());
    }

    protected int singleBLevel(DD bdd, int t) {
        int ti = this.level(bdd);
        if (ti == t) {
            return this.chainEndlevel(bdd);
        }
        if (ti == this.nodeManager.getVarCount() + 1) {
            return ti;
        }
        return ti - 1;
    }

    @Override
    public DD makeCompose(DD f1, int var, DD f2) {
        DD res;
        boolean varInChain;
        int varLevel;
        int hash = HashCodeGenerator.generateHashCode(f1.hashCode(), var, f2.hashCode());
        Cache.CacheDataBinaryOp<DD> data = (Cache.CacheDataBinaryOp<DD>)this.composeCache.get(hash);
        if (data != null && data.matches(f1, f2, var)) {
            return data.getRes();
        }
        int f1Level = this.level(f1);
        if (f1Level > (varLevel = this.nodeManager.level(var))) {
            return f1;
        }
        int f1ChainEndLevel = this.chainEndlevel(f1);
        boolean isChained = f1ChainEndLevel - f1Level > 0;
        boolean bl = varInChain = f1ChainEndLevel >= varLevel;
        if (isChained && varInChain) {
            DD rupturedU = this.rupture(f1, var);
            res = this.makeCompose(rupturedU, var, f2);
        } else if (f1.getVariable() == var) {
            res = this.makeIte(f2, this.nodeManager.getHigh(f1), this.nodeManager.getLow(f1));
        } else {
            DD i = this.makeCompose(this.nodeManager.getHigh(f1), var, f2);
            DD e = this.makeCompose(this.nodeManager.getLow(f1), var, f2);
            res = this.makeIte((DD)this.nodeManager.makeIthVar(f1.getVariable()), i, e);
        }
        data = new Cache.CacheDataBinaryOp<DD>();
        data.setRes(res);
        data.setOp(var);
        data.setF1(f1);
        data.setF2(f2);
        this.composeCache.put(hash, data);
        return res;
    }

    @Override
    public DD makeIte(DD ifBDD, DD thenBDD, DD elseBDD) {
        return this.terminalIteCheck(ifBDD, thenBDD, elseBDD).orElseGet(() -> this.makeIteElse(ifBDD, thenBDD, elseBDD));
    }

    protected DD makeIteElse(DD ifBDD, DD thenBDD, DD elseBDD) {
        int t = this.calculateTLevel(ifBDD, thenBDD, elseBDD);
        int b = this.calculateBLevel(ifBDD, thenBDD, elseBDD, t);
        DD ifLow = this.cofactorLow(ifBDD, b);
        DD thenLow = this.cofactorLow(thenBDD, b);
        DD elseLow = this.cofactorLow(elseBDD, b);
        DD ifHigh = this.cofactorHigh(ifBDD, b);
        DD thenHigh = this.cofactorHigh(thenBDD, b);
        DD elseHigh = this.cofactorHigh(elseBDD, b);
        DD low = this.makeIte(ifLow, thenLow, elseLow);
        DD high = this.makeIte(ifHigh, thenHigh, elseHigh);
        DD res = this.combine(low, high, t, b);
        this.cacheItem(ifBDD, thenBDD, elseBDD, res);
        return res;
    }

    public DD rupture(DD u, int var) {
        int uLevel = this.nodeManager.level(u.getVariable());
        int uChainEndLevel = this.nodeManager.level(this.castToChained(u).getChainEndVariable());
        int vLevel = this.nodeManager.level(var);
        if (vLevel < uLevel || vLevel > uChainEndLevel || uLevel == uChainEndLevel) {
            return u;
        }
        if (uLevel == vLevel) {
            DD hiNode = this.makeChainNode(this.nodeManager.getLow(u), this.nodeManager.getHigh(u), this.nodeManager.var(uLevel + 1), this.nodeManager.var(uChainEndLevel));
            return this.makeChainNode(hiNode, this.nodeManager.getHigh(u), u.getVariable(), u.getVariable());
        }
        if (uChainEndLevel == vLevel) {
            DD hiNode = this.makeChainNode(this.nodeManager.getLow(u), this.nodeManager.getHigh(u), this.castToChained(u).getChainEndVariable(), this.castToChained(u).getChainEndVariable());
            return this.makeChainNode(hiNode, this.nodeManager.getHigh(u), u.getVariable(), this.nodeManager.var(uChainEndLevel - 1));
        }
        DD hiHiNode = this.makeChainNode(this.nodeManager.getLow(u), this.nodeManager.getHigh(u), this.nodeManager.var(vLevel + 1), this.castToChained(u).getChainEndVariable());
        DD hiNode = this.makeChainNode(hiHiNode, this.nodeManager.getHigh(u), var, var);
        return this.makeChainNode(hiNode, this.nodeManager.getHigh(u), u.getVariable(), this.nodeManager.var(vLevel - 1));
    }

    private CDD castToChained(DD bdd) {
        Preconditions.checkArgument((boolean)(bdd instanceof CDD));
        return (CDD)bdd;
    }
}

