/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.cbdd;

import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.cbdd.CBDDApplyAlgorithm;
import org.sosy_lab.pjbdd.core.algorithm.DDAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public class CBDDForkJoinApplyAlgorithm
extends CBDDApplyAlgorithm {
    private final ParallelismManager parallelismManager;

    public CBDDForkJoinApplyAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<DD> nodeManager, ParallelismManager parallelismManager) {
        super(computedTable, nodeManager);
        this.parallelismManager = parallelismManager;
    }

    @Override
    public DD makeOp(DD f1, DD f2, DDAlgorithm.ApplyOp op) {
        return this.terminalCheck(f1, f2, op).orElseGet(() -> this.makeOpElse(f1, f2, op));
    }

    private DD makeOpElse(DD f1, DD f2, DDAlgorithm.ApplyOp op) {
        int t = this.calculateTLevel(f1, f2);
        int b = this.calculateBLevel(f1, f2, t);
        DD low0 = this.cofactorLow(f1, b);
        DD high0 = this.cofactorHigh(f1, b);
        DD low1 = this.cofactorLow(f2, b);
        DD high1 = this.cofactorHigh(f2, b);
        DD low = this.terminalCheck(low0, low1, op).orElse(null);
        DD high = this.terminalCheck(high0, high1, op).orElse(null);
        if (this.parallelismManager.canFork(b) && low == null && high == null) {
            Future lowTask = this.parallelismManager.getThreadPool().submit(() -> this.makeOpElse(low0, low1, op));
            Future highTask = this.parallelismManager.getThreadPool().submit(() -> this.makeOpElse(high0, high1, op));
            low = (DD)((ForkJoinTask)lowTask).join();
            high = (DD)((ForkJoinTask)highTask).join();
        } else {
            if (low == null) {
                low = this.makeOpElse(low0, low1, op);
            }
            if (high == null) {
                high = this.makeOpElse(high0, high1, op);
            }
        }
        DD res = this.combine(low, high, t, b);
        this.cacheBinaryItem(f1, f2, op.ordinal(), res);
        return res;
    }

    @Override
    public DD makeCompose(DD f1, int var, DD f2) {
        DD res;
        boolean varInChain;
        int varLevel;
        int hash = HashCodeGenerator.generateHashCode(f1.hashCode(), var, f2.hashCode());
        Cache.CacheDataBinaryOp<DD> data = (Cache.CacheDataBinaryOp<DD>)this.composeCache.get(hash);
        if (data != null && data.matches(f1, f2, var)) {
            return data.getRes();
        }
        int f1Level = this.level(f1);
        if (f1Level > (varLevel = this.nodeManager.level(var))) {
            return f1;
        }
        int f1ChainEndLevel = this.chainEndlevel(f1);
        boolean isChained = f1ChainEndLevel - f1Level > 0;
        boolean bl = varInChain = f1ChainEndLevel >= varLevel;
        if (isChained && varInChain) {
            DD rupturedU = this.rupture(f1, var);
            res = this.makeCompose(rupturedU, var, f2);
        } else if (f1.getVariable() == var) {
            res = this.makeIte(f2, this.nodeManager.getHigh(f1), this.nodeManager.getLow(f1));
        } else {
            DD elseBdd;
            DD thenBdd;
            if (this.parallelismManager.canFork(f1ChainEndLevel)) {
                Future lowTask = this.parallelismManager.getThreadPool().submit(() -> this.makeCompose(this.nodeManager.getHigh(f1), var, f2));
                Future highTask = this.parallelismManager.getThreadPool().submit(() -> this.makeCompose(this.nodeManager.getLow(f1), var, f2));
                thenBdd = (DD)((ForkJoinTask)lowTask).join();
                elseBdd = (DD)((ForkJoinTask)highTask).join();
            } else {
                thenBdd = this.makeCompose(this.nodeManager.getHigh(f1), var, f2);
                elseBdd = this.makeCompose(this.nodeManager.getLow(f1), var, f2);
            }
            res = this.makeIte((DD)this.nodeManager.makeIthVar(f1.getVariable()), thenBdd, elseBdd);
        }
        data = new Cache.CacheDataBinaryOp<DD>();
        data.setRes(res);
        data.setOp(var);
        data.setF1(f1);
        data.setF2(f2);
        this.composeCache.put(hash, data);
        return res;
    }

    @Override
    protected DD makeIteElse(DD ifBDD, DD thenBDD, DD elseBDD) {
        int t = this.calculateTLevel(ifBDD, thenBDD, elseBDD);
        int b = this.calculateBLevel(ifBDD, thenBDD, elseBDD, t);
        DD ifLow = this.cofactorLow(ifBDD, b);
        DD thenLow = this.cofactorLow(thenBDD, b);
        DD elseLow = this.cofactorLow(elseBDD, b);
        DD ifHigh = this.cofactorHigh(ifBDD, b);
        DD thenHigh = this.cofactorHigh(thenBDD, b);
        DD elseHigh = this.cofactorHigh(elseBDD, b);
        DD low = this.terminalIteCheck(ifLow, thenLow, elseLow).orElse(null);
        DD high = this.terminalIteCheck(ifHigh, thenHigh, elseHigh).orElse(null);
        if (this.parallelismManager.canFork(b) && low == null && high == null) {
            Future lowTask = this.parallelismManager.getThreadPool().submit(() -> this.makeIte(ifLow, thenLow, elseLow));
            Future highTask = this.parallelismManager.getThreadPool().submit(() -> this.makeIte(ifHigh, thenHigh, elseHigh));
            low = (DD)((ForkJoinTask)lowTask).join();
            high = (DD)((ForkJoinTask)highTask).join();
        } else {
            if (low == null) {
                low = this.makeIte(ifLow, thenLow, elseLow);
            }
            if (high == null) {
                high = this.makeIte(ifHigh, thenHigh, elseHigh);
            }
        }
        DD res = this.combine(low, high, t, b);
        this.cacheItem(ifBDD, thenBDD, elseBDD, res);
        return res;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.parallelismManager.shutdown();
    }
}

