/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.cbdd;

import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.cbdd.CDD;
import org.sosy_lab.pjbdd.util.BitMaskIntTupleUtils;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;

public class CBDDNode
implements CDD {
    private final int variableChain;
    private final CBDDNode low;
    private final CBDDNode high;
    private int hashCode;

    public CBDDNode(CBDDNode low, CBDDNode high, int var) {
        this.high = high;
        this.low = low;
        this.variableChain = var;
        this.rehash();
    }

    @Override
    public int getChainEndVariable() {
        return BitMaskIntTupleUtils.getSecond(this.variableChain);
    }

    @Override
    public CBDDNode getHigh() {
        if (this.isLeaf()) {
            return this;
        }
        return this.high;
    }

    @Override
    public boolean isTrue() {
        return this.variableChain == -1;
    }

    @Override
    public boolean isFalse() {
        return this.variableChain == -2;
    }

    @Override
    public int getVariable() {
        return this.variableChain < 0 ? this.variableChain : BitMaskIntTupleUtils.getFirst(this.variableChain);
    }

    @Override
    public CBDDNode getLow() {
        if (this.isLeaf()) {
            return this;
        }
        return this.low;
    }

    protected void rehash() {
        this.hashCode = this.variableChain < 0 ? Math.abs(this.getVariable()) : HashCodeGenerator.generateHashCode(this.getVariable(), this.getChainEndVariable(), this.getLow().hashCode(), this.getHigh().hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CDD)) {
            return false;
        }
        CDD other = (CDD)o;
        if (other.getChainEndVariable() != this.getChainEndVariable()) {
            return false;
        }
        if (other.getVariable() != this.getVariable()) {
            return false;
        }
        return other.getHigh() == this.getHigh() && other.getLow() == this.getLow();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equalsTo(int compVariableChain, DD compLow, DD compHigh) {
        if (compVariableChain != this.variableChain) {
            return false;
        }
        return compHigh == this.getHigh() && compLow == this.getLow();
    }

    public static class Factory
    implements DD.Factory<DD> {
        private CBDDNode one;
        private CBDDNode zero;

        @Override
        public DD createNode(int var, DD low, DD high) {
            return new CBDDNode((CBDDNode)low, (CBDDNode)high, var);
        }

        @Override
        public CBDDNode createTrue() {
            if (this.one == null) {
                this.one = new CBDDNode(null, null, -1);
            }
            return this.one;
        }

        @Override
        public CBDDNode createFalse() {
            if (this.zero == null) {
                this.zero = new CBDDNode(null, null, -2);
            }
            return this.zero;
        }

        @Override
        public void setLow(DD low, DD node) {
        }

        @Override
        public void setHigh(DD high, DD node) {
        }

        @Override
        public void setVariable(int variable, DD node) {
        }

        @Override
        public DD.ChildNodeResolver<DD> getChildNodeResolver() {
            return new DD.ChildNodeResolver<DD>(){

                @Override
                public DD getLow(DD root) {
                    return root.getLow();
                }

                @Override
                public DD getHigh(DD root) {
                    return root.getHigh();
                }

                @Override
                public CBDDNode cast(Object root) {
                    return (CBDDNode)root;
                }
            };
        }
    }
}

