/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.cbdd;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.cbdd.CDD;
import org.sosy_lab.pjbdd.core.algorithm.SatAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.BitMaskIntTupleUtils;

public class CBDDSat
implements SatAlgorithm<DD> {
    protected final Cache<DD, BigInteger> satCountCache;
    protected final NodeManager<DD> nodeManager;

    public CBDDSat(Cache<DD, BigInteger> satCountCache, NodeManager<DD> nodeManager) {
        this.satCountCache = satCountCache;
        this.nodeManager = nodeManager;
    }

    @Override
    public BigInteger satCount(DD b) {
        return BigInteger.valueOf(2L).pow(this.level(b)).multiply(this.satCountRec(b));
    }

    protected BigInteger satCountRec(DD root) {
        if (root.isFalse()) {
            return BigInteger.ZERO;
        }
        if (root.isTrue()) {
            return BigInteger.ONE;
        }
        BigInteger count = this.satCountCache.get(root);
        if (count != null) {
            return count;
        }
        BigInteger s = BigInteger.valueOf(2L).pow(this.level(root.getLow()) - this.chainEndLevel(root) - 1);
        BigInteger size = s.multiply(this.satCountRec(this.nodeManager.getLow(root)));
        s = this.selfValue(this.level(root), this.chainEndLevel(root), this.level(root.getHigh()));
        size = size.add(s.multiply(this.satCountRec(this.nodeManager.getHigh(root))));
        this.satCountCache.put(root, size);
        return size;
    }

    private int level(DD bdd) {
        return this.nodeManager.level(bdd.getVariable());
    }

    private int chainEndLevel(DD bdd) {
        return this.nodeManager.level(this.castToChained(bdd).getChainEndVariable());
    }

    private BigInteger selfValue(int level, int chainEndLevel, int childLevel) {
        int n = childLevel - level;
        int m = childLevel - chainEndLevel;
        return BigInteger.valueOf(2L).pow(n).subtract(BigInteger.valueOf(2L).pow(m - 1));
    }

    @Override
    public DD anySat(DD bdd) {
        if (bdd.isLeaf()) {
            return bdd;
        }
        if (bdd.getLow().isFalse()) {
            return this.nodeManager.makeNode(this.nodeManager.getFalse(), this.anySat(this.nodeManager.getHigh(bdd)), BitMaskIntTupleUtils.createTuple(bdd.getVariable(), this.castToChained(bdd).getChainEndVariable()));
        }
        return this.nodeManager.makeNode(this.anySat(this.nodeManager.getLow(bdd)), this.nodeManager.getFalse(), BitMaskIntTupleUtils.createTuple(bdd.getVariable(), this.castToChained(bdd).getChainEndVariable()));
    }

    private CDD castToChained(DD bdd) {
        Preconditions.checkArgument((boolean)(bdd instanceof CDD));
        return (CDD)bdd;
    }
}

