/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.algorithm;

import java.util.Optional;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.algorithm.Algorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;

public abstract class ManipulatingAlgorithm<V extends DD>
implements Algorithm<V> {
    protected final NodeManager<V> nodeManager;
    protected final Cache<Integer, Cache.CacheData> computedTable;

    public ManipulatingAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager) {
        this.nodeManager = nodeManager;
        this.computedTable = computedTable;
    }

    @Override
    public void shutdown() {
        this.nodeManager.shutdown();
        this.computedTable.clear();
    }

    @Override
    public V makeFalse() {
        return this.nodeManager.getFalse();
    }

    @Override
    public V makeTrue() {
        return this.nodeManager.getTrue();
    }

    @Override
    public V makeNode(V low, V high, int var) {
        if (!this.nodeManager.checkLvl(var)) {
            this.nodeManager.setVarCount(var + 1);
        }
        return this.nodeManager.makeNode(low, high, var);
    }

    @Override
    public V restrict(V bdd, int var, boolean restrictionVar) {
        return bdd.getVariable() != var ? bdd : (restrictionVar ? this.nodeManager.getHigh(bdd) : this.nodeManager.getLow(bdd));
    }

    protected V low(V f, int topVar) {
        return this.restrict(f, topVar, false);
    }

    protected V high(V f, int topVar) {
        return this.restrict(f, topVar, true);
    }

    protected int topVar(int ... levels) {
        return this.nodeManager.topVar(levels);
    }

    protected int level(V bdd) {
        return this.nodeManager.level(bdd.getVariable());
    }

    protected Optional<V> checkITECache(V f1, V f2, V f3) {
        Cache.CacheDataITE d;
        int hash = HashCodeGenerator.generateHashCode(f1.hashCode(), f2.hashCode(), f3.hashCode());
        Cache.CacheData data = this.computedTable.get(hash);
        if (data instanceof Cache.CacheDataITE && (d = (Cache.CacheDataITE)data).getF1().equals(f1) && d.getF2().equals(f2) && d.getF3().equals(f3)) {
            return Optional.of(d.getRes());
        }
        return Optional.empty();
    }

    protected void cacheItem(V f1, V f2, V f3, V item) {
        Cache.CacheDataITE<V> data = new Cache.CacheDataITE<V>();
        data.setF1(f1);
        data.setF2(f2);
        data.setF3(f3);
        data.setRes(item);
        int hash = HashCodeGenerator.generateHashCode(f1.hashCode(), f2.hashCode(), f3.hashCode());
        this.cache(this.computedTable, data, hash);
    }

    protected void cache(Cache<Integer, Cache.CacheData> cache, Cache.CacheData data, int hash) {
        cache.put(hash, data);
    }

    protected void cacheBinaryItem(V f1, V f2, int op, V item) {
        Cache.CacheDataBinaryOp<V> data = new Cache.CacheDataBinaryOp<V>();
        data.setF1(f1);
        data.setF2(f2);
        data.setOp(op);
        data.setRes(item);
        int hash = HashCodeGenerator.generateHashCode(f1.hashCode(), f2.hashCode(), op);
        this.cacheEntry(data, hash);
    }

    protected void cacheUnaryItem(V f, V item) {
        Cache.CacheDataNot<V> data = new Cache.CacheDataNot<V>();
        data.setF(f);
        data.setRes(item);
        int hash = f.hashCode();
        this.cacheEntry(data, hash);
    }

    private void cacheEntry(Cache.CacheData data, int hash) {
        this.computedTable.put(hash, data);
    }

    protected Optional<V> checkBinaryCache(V f1, V f2, int op) {
        Cache.CacheDataBinaryOp d;
        int hash = HashCodeGenerator.generateHashCode(f1.hashCode(), f2.hashCode(), op);
        Cache.CacheData data = this.computedTable.get(hash);
        if (data instanceof Cache.CacheDataBinaryOp && (d = (Cache.CacheDataBinaryOp)data).getF1().equals(f1) && d.getF2().equals(f2) && d.getOp() == op) {
            return Optional.of(d.getRes());
        }
        return Optional.empty();
    }

    protected Optional<V> checkNotCache(V f) {
        Cache.CacheDataNot d;
        int hash = f.hashCode();
        Cache.CacheData data = this.computedTable.get(hash);
        if (data instanceof Cache.CacheDataNot && (d = (Cache.CacheDataNot)data).getF().equals(f)) {
            return Optional.of(d.getRes());
        }
        return Optional.empty();
    }

    @Override
    public int getCacheSize() {
        return this.computedTable.size();
    }

    @Override
    public int getCacheNodeCount() {
        return this.computedTable.nodeCount();
    }

    protected V getLow(V root) {
        return this.nodeManager.getLow(root);
    }

    protected V getHigh(V root) {
        return this.nodeManager.getHigh(root);
    }
}

