/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.cache;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.cache.Cache;

public class ArrayCache<V extends DD>
implements Cache<Integer, Cache.CacheData> {
    private Cache.CacheData[] cache;

    @Override
    public void init(int cacheSize, int parallelism) {
        this.cache = new Cache.CacheData[cacheSize];
    }

    @Override
    public void clear() {
        IntStream.range(0, this.cache.length).forEach(i -> {
            this.cache[i] = null;
        });
    }

    @Override
    public void put(Integer key, Cache.CacheData value) {
        int index = Math.abs(key % this.cache.length);
        this.cache[index] = value;
    }

    @Override
    public Cache.CacheData get(Integer key) {
        int index = Math.abs(key % this.cache.length);
        return this.cache[index];
    }

    @Override
    public Cache<Integer, Cache.CacheData> cleanCopy() {
        ArrayCache<V> copy = new ArrayCache<V>();
        copy.init(this.cache.length, 0);
        return copy;
    }

    @Override
    public int nodeCount() {
        return (int)Arrays.stream(this.cache).filter(Objects::nonNull).count();
    }

    @Override
    public int size() {
        return this.cache.length;
    }
}

