/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.cache;

import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.util.IntArrayUtils;

public interface Cache<K, V> {
    public void init(int var1, int var2);

    public void clear();

    public void put(K var1, V var2);

    public V get(K var1);

    public Cache<K, V> cleanCopy();

    public int nodeCount();

    public int size();

    public static class CacheDataITE<V extends DD>
    implements CacheData {
        private V f1;
        private V f2;
        private V f3;
        private V res;

        public V getF1() {
            return this.f1;
        }

        public void setF1(V f1) {
            this.f1 = f1;
        }

        public V getF2() {
            return this.f2;
        }

        public void setF2(V f2) {
            this.f2 = f2;
        }

        public V getF3() {
            return this.f3;
        }

        public void setF3(V f3) {
            this.f3 = f3;
        }

        public V getRes() {
            return this.res;
        }

        public void setRes(V res) {
            this.res = res;
        }
    }

    public static interface CacheData {
    }

    public static class CacheDataNot<V extends DD>
    implements CacheData {
        private V f;
        private V res;

        public V getF() {
            return this.f;
        }

        public void setF(V f) {
            this.f = f;
        }

        public V getRes() {
            return this.res;
        }

        public void setRes(V res) {
            this.res = res;
        }
    }

    public static class CacheDataExQuant<V extends DD>
    implements CacheData {
        private V f;
        private V res;
        private int level;

        public V getF() {
            return this.f;
        }

        public void setF(V f) {
            this.f = f;
        }

        public V getRes() {
            return this.res;
        }

        public void setRes(V res) {
            this.res = res;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }
    }

    public static class CacheDataExQuantVararg<V extends DD>
    implements CacheData {
        private V f;
        private V res;
        private int[] levels;

        public boolean matches(V node, int ... mValues) {
            return this.f.equals(node) && IntArrayUtils.equals(this.levels, mValues);
        }

        public V getF() {
            return this.f;
        }

        public void setF(V f) {
            this.f = f;
        }

        public V getRes() {
            return this.res;
        }

        public void setRes(V res) {
            this.res = res;
        }

        public void setLevels(int ... levels) {
            this.levels = levels;
        }
    }

    public static class CacheDataBinaryOp<V extends DD>
    implements CacheData {
        private V f1;
        private V f2;
        private V res;
        private int op;

        public V getF1() {
            return this.f1;
        }

        public void setF1(V f1) {
            this.f1 = f1;
        }

        public V getF2() {
            return this.f2;
        }

        public void setF2(V f2) {
            this.f2 = f2;
        }

        public V getRes() {
            return this.res;
        }

        public void setRes(V res) {
            this.res = res;
        }

        public int getOp() {
            return this.op;
        }

        public void setOp(int op) {
            this.op = op;
        }

        public boolean matches(V tF1, V tF2, int var) {
            return tF1.equals(this.getF1()) && tF2.equals(this.getF2()) && var == this.getOp();
        }
    }
}

