/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.cache;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.cache.Cache;

public class ConcurrentArrayCache<V extends DD>
implements Cache<Integer, Cache.CacheData> {
    private Cache.CacheData[] cache;
    private Lock[] locks;

    @Override
    public void init(int cacheSize, int parallelism) {
        this.cache = new Cache.CacheData[cacheSize];
        this.locks = new ReentrantLock[parallelism];
        for (int i = 0; i < parallelism; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public void clear() {
        IntStream.range(0, this.cache.length).forEach(i -> {
            this.cache[i] = null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Integer key, Cache.CacheData value) {
        int index = Math.abs(key % this.cache.length);
        Lock lock = this.locks[index % this.locks.length];
        lock.lock();
        try {
            this.cache[index] = value;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache.CacheData get(Integer key) {
        int index = Math.abs(key % this.cache.length);
        Lock lock = this.locks[index % this.locks.length];
        lock.lock();
        try {
            Cache.CacheData cacheData = this.cache[index];
            return cacheData;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Cache<Integer, Cache.CacheData> cleanCopy() {
        ConcurrentArrayCache<V> copy = new ConcurrentArrayCache<V>();
        copy.init(this.cache.length, this.locks.length);
        return copy;
    }

    @Override
    public int nodeCount() {
        return (int)Arrays.stream(this.cache).filter(Objects::nonNull).count();
    }

    @Override
    public int size() {
        return this.cache.length;
    }
}

