/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.cache;

import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.pjbdd.core.cache.Cache;

public class GuavaCache<K, V>
implements Cache<K, V> {
    private com.google.common.cache.Cache<K, V> cache;
    private int lockCount;
    private int cacheSize;

    @Override
    public void init(int size, int parallelism) {
        this.cacheSize = size;
        this.lockCount = parallelism;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.cacheSize).concurrencyLevel(parallelism).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public V get(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public Cache<K, V> cleanCopy() {
        GuavaCache<K, V> copy = new GuavaCache<K, V>();
        copy.init(this.cacheSize, this.lockCount);
        return copy;
    }

    @Override
    public int nodeCount() {
        return (int)this.cache.size();
    }

    @Override
    public int size() {
        return this.cacheSize;
    }
}

