/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.node;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.core.node.ReductionRule;
import org.sosy_lab.pjbdd.core.uniquetable.UniqueTable;

public class NodeManagerImpl<V extends DD>
implements NodeManager<V> {
    protected int varCount;
    protected int[] levelVar;
    protected int[] varLevel;
    protected final ReductionRule<V> reductionRule;
    protected Set<V> varSet;
    protected final UniqueTable<V> uniqueTable;

    public NodeManagerImpl(UniqueTable<V> uniqueTable, ReductionRule<V> reductionRule) {
        this.reductionRule = reductionRule;
        this.uniqueTable = uniqueTable;
    }

    @Override
    public int var(int level) {
        return this.levelVar[level];
    }

    @Override
    public int setVarCount(int count) {
        if (count < 1 || count <= this.varCount) {
            return this.varCount;
        }
        int oldCount = this.varCount;
        this.varCount = count;
        if (this.varSet == null) {
            this.varSet = Collections.synchronizedSet(new HashSet());
            this.levelVar = new int[this.varCount];
            this.varLevel = new int[this.varCount];
        } else {
            int[] newLevelVar = new int[this.varCount];
            int[] newVarLevel = new int[this.varCount];
            System.arraycopy(this.levelVar, 0, newLevelVar, 0, this.levelVar.length);
            System.arraycopy(this.varLevel, 0, newVarLevel, 0, this.levelVar.length);
            this.levelVar = newLevelVar;
            this.varLevel = newVarLevel;
        }
        for (int i = oldCount; i < count; ++i) {
            this.makeVariable(i);
        }
        return this.varCount;
    }

    @Override
    public int getNext(int lvl) {
        if (lvl >= this.levelVar.length) {
            throw new IndexOutOfBoundsException("no such variable");
        }
        return this.levelVar[lvl + 1];
    }

    @Override
    public int level(int variable) {
        return variable < 0 ? this.varCount : this.varLevel[variable];
    }

    @Override
    public int getVarCount() {
        return this.varCount;
    }

    @Override
    public int[] getCurrentOrdering() {
        return Arrays.copyOf(this.levelVar, this.levelVar.length);
    }

    @Override
    public boolean checkLvl(int level) {
        return level < this.varCount;
    }

    @Override
    public void setVarOrder(List<Integer> pOrder) {
        int max = Collections.max(pOrder);
        if (!this.checkLvl(max)) {
            this.setVarCount(max);
        }
        IntStream.range(0, pOrder.size()).forEach(i -> {
            if (!Objects.equals(pOrder.get(i), this.levelVar[i])) {
                this.swapVarToLevel((Integer)pOrder.get(i), i);
            }
        });
    }

    @Override
    public int topVar(int[] levels) {
        return this.var(Ints.min((int[])levels));
    }

    @Override
    public V makeNode(V low, V high, int var) {
        return (V)this.reductionRule.apply(low, high, var).orElseGet(() -> this.uniqueTable.getOrCreate((DD)low, (DD)high, var));
    }

    @Override
    public V getFalse() {
        return this.uniqueTable.getFalse();
    }

    @Override
    public V getTrue() {
        return this.uniqueTable.getTrue();
    }

    @Override
    public void shutdown() {
        this.varLevel = null;
        this.levelVar = null;
        this.varSet.clear();
        this.uniqueTable.shutDown();
    }

    @Override
    public V getHigh(V bdd) {
        return this.uniqueTable.getHigh(bdd);
    }

    @Override
    public V getLow(V bdd) {
        return this.uniqueTable.getLow(bdd);
    }

    @Override
    public int getNodeCount() {
        return this.uniqueTable.nodeCount() + 2;
    }

    @Override
    public int getUniqueTableSize() {
        return this.uniqueTable.size();
    }

    @Override
    public V makeVariableBefore(V var) {
        V newVariable = this.makeNext();
        int newLevel = this.level(var.getVariable());
        int i = this.levelVar.length - 2;
        while (i + 1 > newLevel) {
            int newVarIndex = this.levelVar[i];
            this.levelVar[i + 1] = this.levelVar[i];
            this.varLevel[newVarIndex] = i + 1;
            --i;
        }
        this.levelVar[newLevel] = newVariable.getVariable();
        this.varLevel[newVariable.getVariable()] = newLevel;
        return newVariable;
    }

    @Override
    public void cleanUnusedNodes() {
        this.uniqueTable.cleanUnusedNodes();
    }

    private void swapVarToLevel(int var, int level) {
        int levelOfVar = this.varLevel[var];
        while (levelOfVar != level) {
            if (levelOfVar < level) {
                this.swapLevel(levelOfVar + 1, levelOfVar++);
                continue;
            }
            this.swapLevel(levelOfVar--, levelOfVar);
        }
    }

    private void swapLevel(int levelA, int levelB) {
        int varA = this.levelVar[levelA];
        int varB = this.levelVar[levelB];
        this.varLevel[varA] = levelB;
        this.varLevel[varB] = levelA;
        this.levelVar[levelB] = varA;
        this.levelVar[levelA] = varB;
        this.uniqueTable.swap(varA, varB, this::makeNode);
    }

    @Override
    public V makeNext() {
        return this.makeVariable(this.varCount);
    }

    private V makeVariable(int var) {
        if (!this.checkLvl(var)) {
            this.setVarCount(var + 1);
        }
        V posVar = this.makeNode(this.getFalse(), this.getTrue(), var);
        this.varSet.add(posVar);
        this.levelVar[var] = var;
        this.varLevel[var] = var;
        V negVar = this.makeNode(this.getTrue(), this.getFalse(), var);
        this.varSet.add(negVar);
        return posVar;
    }
}

