/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.uniquetable;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.uniquetable.CASWeakDDArray;
import org.sosy_lab.pjbdd.core.uniquetable.UniqueTable;
import org.sosy_lab.pjbdd.core.uniquetable.WeakArrayUniqueTable;
import org.sosy_lab.pjbdd.util.PrimeUtils;

public class DDCASArrayUniqueTable<V extends DD>
extends WeakArrayUniqueTable<V>
implements UniqueTable<V> {
    private static final VarHandle HASH_HANDLE = MethodHandles.arrayElementVarHandle(int[].class);
    private static final VarHandle COLLECTED_COUNTER_HANDLE;
    private static final VarHandle FREE_COUNTER_HANDLE;
    private static final VarHandle NEXT_FREE_HANDLE;
    private final Lock resizeMonitor = new ReentrantLock();
    private volatile boolean resizeInProgress = false;

    public DDCASArrayUniqueTable(int increaseFactor, int initialSize, DD.Factory<V> factory) {
        super(increaseFactor, initialSize, factory);
        this.nodeCount = PrimeUtils.getGreaterNextPrime(initialSize);
        this.initIntern();
    }

    @Override
    public V getOrCreate(V low, V high, int var) {
        int head = this.getNodeWithHash(this.hashNode(var, low.hashCode(), high.hashCode()));
        V bdd = this.get(low, high, var);
        if (bdd != null) {
            return bdd;
        }
        int res = this.getNextFree();
        if (res > 1) {
            this.atomicDecrementFreeCounter();
            return this.createAtomic(low, high, var, res, head);
        }
        this.tryResizing();
        return this.getOrCreate(low, high, var);
    }

    @Override
    protected V get(V low, V high, int var) {
        int hash = this.hashNode(var, low.hashCode(), high.hashCode());
        int res = this.getNodeWithHash(hash);
        while (res != 0) {
            if (this.table.get(res) == null) {
                res = this.getNext(res);
                continue;
            }
            Object bdd = this.table.get(res);
            if (bdd == null) {
                res = this.getNext(res);
                continue;
            }
            if (bdd.equalsTo(var, (DD)low, (DD)high)) {
                return bdd;
            }
            res = this.getNext(res);
        }
        return null;
    }

    protected V createAtomic(V low, V high, int var, int res, int head) {
        this.atomicDecrementFreeCounter();
        int hash = this.hashNode(var, low.hashCode(), high.hashCode());
        if (!this.setHashAtomic(hash, res, head)) {
            return this.getOrCreate(low, high, var);
        }
        this.setNext(res, head);
        V result = this.factory.createNode(var, low, high);
        this.table.set(res, result);
        return result;
    }

    protected boolean setHashAtomic(int hash, int res, int old) {
        return HASH_HANDLE.weakCompareAndSetPlain(this.hashTable, hash, old, res);
    }

    @Override
    protected void tryResizing() {
        block7: {
            if (this.checkResize()) {
                this.resizeMonitor.lock();
                try {
                    if (!this.checkResize()) break block7;
                    this.resizeInProgress = true;
                    try {
                        this.resizeTable();
                    }
                    finally {
                        this.resizeInProgress = false;
                    }
                }
                finally {
                    this.resizeMonitor.unlock();
                }
            }
        }
    }

    @Override
    protected boolean checkResize() {
        if (this.nextFree > 1) {
            return this.resizeInProgress;
        }
        return true;
    }

    @Override
    public void forEach(Consumer<V> bddConsumer) {
        this.table.toStream().forEach(bddConsumer);
    }

    @Override
    protected void initIntern() {
        this.resizeInProgress = false;
        this.one = this.factory.createTrue();
        this.zero = this.factory.createFalse();
        this.table = new CASWeakDDArray(this.nodeCount, this.factory.getChildNodeResolver());
        this.nextTable = new int[this.nodeCount];
        this.hashTable = new int[this.nodeCount];
        for (int n = 0; n < this.nodeCount; ++n) {
            this.setNext(n, n + 1);
        }
        this.setNext(this.nodeCount - 1, 0);
        this.nextFree = 2;
        this.atomicSetFreeCounter(this.nodeCount - 2);
    }

    @Override
    protected void setNext(int index, int next) {
        if (index != next) {
            this.nextTable[index] = next;
        }
    }

    @Override
    protected int getNext(int index) {
        return this.nextTable[index];
    }

    @Override
    protected void resizeTable() {
        int oldSize = this.nodeCount;
        int newSize = this.nodeCount;
        if ((double)this.atomicReadCollectedCounter() >= (double)this.nodeCount * 0.2) {
            this.doResize(oldSize, newSize);
        } else {
            super.resizeTable();
        }
        this.atomicResetCollectedCounter();
    }

    private void atomicDecrementFreeCounter() {
        this.freeCounter = FREE_COUNTER_HANDLE.getAndAdd(this, -1);
    }

    private int atomicReadCollectedCounter() {
        return COLLECTED_COUNTER_HANDLE.get(this);
    }

    private void atomicResetCollectedCounter() {
        COLLECTED_COUNTER_HANDLE.set(this, 0);
    }

    private void atomicSetFreeCounter(int value) {
        FREE_COUNTER_HANDLE.set(this, value);
    }

    private boolean atomicSetNextFree(int value, int old) {
        return NEXT_FREE_HANDLE.weakCompareAndSetPlain(this, old, value);
    }

    @Override
    protected int getNextFree() {
        int next = NEXT_FREE_HANDLE.get(this);
        if (this.atomicSetNextFree(this.getNext(next), next)) {
            return next;
        }
        return this.getNextFree();
    }

    static {
        try {
            COLLECTED_COUNTER_HANDLE = MethodHandles.lookup().findVarHandle(WeakArrayUniqueTable.class, "collectedCount", Integer.TYPE);
            FREE_COUNTER_HANDLE = MethodHandles.lookup().findVarHandle(WeakArrayUniqueTable.class, "freeCounter", Integer.TYPE);
            NEXT_FREE_HANDLE = MethodHandles.lookup().findVarHandle(WeakArrayUniqueTable.class, "nextFree", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

