/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.uniquetable;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.uniquetable.UniqueTable;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;
import org.sosy_lab.pjbdd.util.reference.ComparableWeakBDDReference;
import org.sosy_lab.pjbdd.util.reference.ReclaimedReferenceCleaningThread;

public class DDConcurrentWeakHashDeque<V extends DD>
implements UniqueTable<V> {
    private final ConcurrentMap<Integer, Deque<WeakReference<V>>> weakValuesHashBucket;
    private final ReferenceQueue<V> referenceQueue;
    private final LongAdder size;
    private V zero;
    private V one;
    private final DD.Factory<V> factory;
    private final CleanUpThread cleaner;
    private final DD.ChildNodeResolver<V> resolver;

    public DDConcurrentWeakHashDeque(int tableSize, int parallelism, DD.Factory<V> factory) {
        this.weakValuesHashBucket = new ConcurrentHashMap<Integer, Deque<WeakReference<V>>>(tableSize, 0.75f, parallelism);
        this.referenceQueue = new ReferenceQueue();
        this.size = new LongAdder();
        this.factory = factory;
        this.one = factory.createTrue();
        this.zero = factory.createFalse();
        this.resolver = factory.getChildNodeResolver();
        this.cleaner = new CleanUpThread();
        this.cleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getOrCreate(V low, V high, int var) {
        int hash = HashCodeGenerator.generateHashCode(var, low.hashCode(), high.hashCode());
        if (this.weakValuesHashBucket.containsKey(hash)) {
            Deque deque = (Deque)this.weakValuesHashBucket.get(hash);
            synchronized (deque) {
                for (Reference ref : (Deque)this.weakValuesHashBucket.get(hash)) {
                    V value = this.resolver.cast(ref.get());
                    if (value == null || !value.equalsTo(var, (DD)low, (DD)high)) continue;
                    return value;
                }
            }
        }
        return this.add(this.factory.createNode(var, low, high));
    }

    private V add(V node) {
        if (node.isTrue()) {
            this.one = node;
        } else if (node.isFalse()) {
            this.zero = node;
        } else {
            ComparableWeakBDDReference<V> ref = new ComparableWeakBDDReference<V>(node, this.referenceQueue);
            this.weakValuesHashBucket.putIfAbsent(node.hashCode(), new ConcurrentLinkedDeque());
            ((Deque)this.weakValuesHashBucket.get(node.hashCode())).add(ref);
        }
        this.size.increment();
        return node;
    }

    @Override
    public void clear() {
        this.weakValuesHashBucket.clear();
        this.size.reset();
    }

    @Override
    public V getTrue() {
        return this.one;
    }

    @Override
    public V getFalse() {
        return this.zero;
    }

    @Override
    public void shutDown() {
        this.clear();
        this.cleaner.shutdown();
    }

    @Override
    public DD.Factory<V> getFactory() {
        return this.factory;
    }

    @Override
    public int nodeCount() {
        return (int)this.toStream().count();
    }

    @Override
    public int size() {
        return (int)this.toStream().count();
    }

    @Override
    public void cleanUnusedNodes() {
        Reference<V> ref = this.referenceQueue.poll();
        while (ref != null) {
            if (ref instanceof ComparableWeakBDDReference) {
                this.removeReference((ComparableWeakBDDReference)ref);
            }
            ref = this.referenceQueue.poll();
        }
    }

    private Stream<V> toStream() {
        return this.weakValuesHashBucket.values().stream().flatMap(Collection::stream).map(Reference::get).filter(Objects::nonNull);
    }

    @Override
    public void forEach(Consumer<V> bddConsumer) {
        this.toStream().forEach(bddConsumer);
    }

    @Override
    public V getLow(V root) {
        return this.resolver.getLow(root);
    }

    @Override
    public V getHigh(V root) {
        return this.resolver.getHigh(root);
    }

    @Override
    public void rehash(V node, int oldHash) {
        if (node.hashCode() != oldHash) {
            for (WeakReference next : (Deque)this.weakValuesHashBucket.getOrDefault(oldHash, new ArrayDeque())) {
                if (!Objects.equals(next.get(), node)) continue;
                this.removeReference(next);
                break;
            }
            this.add(node);
        }
    }

    private void removeReference(WeakReference<? extends DD> reference) {
        int hash = reference.hashCode();
        ((Deque)this.weakValuesHashBucket.getOrDefault(hash, new ArrayDeque())).remove(reference);
        this.size.decrement();
    }

    private class CleanUpThread
    extends ReclaimedReferenceCleaningThread {
        private CleanUpThread() {
        }

        @Override
        protected void deleteReclaimedEntries() throws InterruptedException {
            Reference reference = DDConcurrentWeakHashDeque.this.referenceQueue.remove(1000L);
            if (reference != null && reference instanceof ComparableWeakBDDReference && !this.isShutdown()) {
                DDConcurrentWeakHashDeque.this.removeReference((ComparableWeakBDDReference)reference);
            }
        }
    }
}

