/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.uniquetable;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.uniquetable.UniqueTable;
import org.sosy_lab.pjbdd.util.reference.ComparableWeakBDDReference;
import org.sosy_lab.pjbdd.util.reference.ReclaimedReferenceCleaningThread;

public class DDConcurrentWeakHashMap<V extends DD>
implements UniqueTable<V> {
    private final ConcurrentMap<ComparableWeakBDDReference<V>, WeakReference<V>> map;
    private final ReferenceQueue<V> referenceQueue;
    private final V zero;
    private final V one;
    private final DD.Factory<V> factory;
    private final CleanUpThread cleaner;
    private final DD.ChildNodeResolver<V> resolver;

    public DDConcurrentWeakHashMap(int initialCapacity, int parallelism, DD.Factory<V> factory) {
        this.map = new ConcurrentHashMap<ComparableWeakBDDReference<V>, WeakReference<V>>(initialCapacity, 0.75f, parallelism);
        this.referenceQueue = new ReferenceQueue();
        this.cleaner = new CleanUpThread();
        this.factory = factory;
        this.zero = factory.createFalse();
        this.one = factory.createTrue();
        this.resolver = factory.getChildNodeResolver();
        this.startCleaner();
    }

    private void startCleaner() {
        this.cleaner.start();
    }

    @Override
    public void forEach(Consumer<V> bddConsumer) {
        this.map.values().stream().map(Reference::get).filter(Objects::nonNull).forEach(bddConsumer);
    }

    @Override
    public V getLow(V root) {
        return this.resolver.getLow(root);
    }

    @Override
    public V getHigh(V root) {
        return this.resolver.getHigh(root);
    }

    @Override
    public void rehash(DD node, int oldHash) {
    }

    @Override
    public DD.Factory<V> getFactory() {
        return this.factory;
    }

    @Override
    public int nodeCount() {
        return this.map.size();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void cleanUnusedNodes() {
        Reference<V> ref = this.referenceQueue.poll();
        while (ref != null) {
            if (ref instanceof ComparableWeakBDDReference) {
                this.map.remove(ref);
            }
            ref = this.referenceQueue.poll();
        }
    }

    @Override
    public V getOrCreate(V low, V high, int var) {
        V lookUp = this.factory.createNode(var, low, high);
        ComparableWeakBDDReference<V> ref = new ComparableWeakBDDReference<V>(lookUp, this.referenceQueue);
        WeakReference refRes = this.map.putIfAbsent(ref, ref);
        if (refRes == null) {
            return lookUp;
        }
        DD res = (DD)refRes.get();
        if (res != null) {
            return (V)res;
        }
        return this.getOrCreate(low, high, var);
    }

    @Override
    public V getTrue() {
        return this.one;
    }

    @Override
    public V getFalse() {
        return this.zero;
    }

    @Override
    public void shutDown() {
        this.cleaner.shutdown();
        this.clear();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    private class CleanUpThread
    extends ReclaimedReferenceCleaningThread {
        private CleanUpThread() {
        }

        @Override
        protected void deleteReclaimedEntries() throws InterruptedException {
            Reference sv = DDConcurrentWeakHashMap.this.referenceQueue.remove(1000L);
            if (sv != null && sv instanceof ComparableWeakBDDReference) {
                DDConcurrentWeakHashMap.this.map.remove(sv);
            }
        }
    }
}

