/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.uniquetable;

import java.util.function.Consumer;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.uniquetable.UniqueTable;
import org.sosy_lab.pjbdd.core.uniquetable.WeakDDArray;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;
import org.sosy_lab.pjbdd.util.PrimeUtils;

public class WeakArrayUniqueTable<V extends DD>
implements UniqueTable<V> {
    protected final double onlyCleanThreshold = 0.2;
    protected int collectedCount = 0;
    protected WeakDDArray<V> table;
    protected int[] hashTable;
    protected int[] nextTable;
    protected V one;
    protected V zero;
    protected final DD.Factory<V> factory;
    protected final DD.ChildNodeResolver<V> resolver;
    protected int maxSize = Integer.MAX_VALUE;
    protected int nextFree = 0;
    protected int freeCounter = 0;
    protected int nodeCount;
    protected int increaseFactor;

    public WeakArrayUniqueTable(int increaseFactor, int initialSize, DD.Factory<V> factory) {
        this.factory = factory;
        this.resolver = factory.getChildNodeResolver();
        this.increaseFactor = increaseFactor;
        this.nodeCount = PrimeUtils.getGreaterNextPrime(initialSize);
        this.initIntern();
    }

    @Override
    public V getOrCreate(V low, V high, int var) {
        int head = this.getNodeWithHash(this.hashNode(var, low.hashCode(), high.hashCode()));
        V bdd = this.get(low, high, var);
        if (bdd != null) {
            return bdd;
        }
        int res = this.getNextFree();
        if (res > 1) {
            return this.create(low, high, var, res, head);
        }
        this.tryResizing();
        return this.getOrCreate(low, high, var);
    }

    protected V get(V low, V high, int var) {
        int hash = this.hashNode(var, low.hashCode(), high.hashCode());
        int res = this.getNodeWithHash(hash);
        while (res != 0) {
            if (this.table.get(res) == null) {
                res = this.getNext(res);
                continue;
            }
            V bdd = this.table.get(res);
            if (bdd == null) {
                res = this.getNext(res);
                continue;
            }
            if (bdd.equalsTo(var, (DD)low, (DD)high)) {
                return bdd;
            }
            res = this.getNext(res);
        }
        return null;
    }

    protected V create(V low, V high, int var, int res, int head) {
        --this.freeCounter;
        int hash = this.hashNode(var, low.hashCode(), high.hashCode());
        this.setHash(hash, res);
        this.setNext(res, head);
        V result = this.factory.createNode(var, low, high);
        this.table.set(res, result);
        return result;
    }

    protected void tryResizing() {
        if (this.checkResize()) {
            this.resizeTable();
        }
    }

    @Override
    public void forEach(Consumer<V> bddConsumer) {
        this.table.toStream().forEach(bddConsumer);
    }

    protected void initIntern() {
        this.freeCounter = 2;
        this.one = this.factory.createTrue();
        this.zero = this.factory.createFalse();
        this.table = new WeakDDArray<V>(this.nodeCount, this.factory.getChildNodeResolver());
        this.nextTable = new int[this.nodeCount];
        this.hashTable = new int[this.nodeCount];
        for (int n = 0; n < this.nodeCount; ++n) {
            this.setNext(n, n + 1);
        }
        this.setNext(this.nodeCount - 1, 0);
        this.nextFree = 2;
        this.freeCounter = this.nodeCount - 2;
    }

    protected void setNext(int index, int next) {
        if (index != next) {
            this.nextTable[index] = next;
        }
    }

    protected int getNext(int index) {
        return this.nextTable[index];
    }

    protected void resizeTable() {
        int oldSize = this.nodeCount;
        int newSize = this.nodeCount;
        if ((double)(this.freeCounter + this.collectedCount) < (double)this.nodeCount * 0.2) {
            newSize = this.increaseFactor > 0 ? (newSize += newSize * this.increaseFactor) : (newSize <<= 1);
            if (newSize > this.maxSize) {
                newSize = this.maxSize;
            }
        }
        this.doResize(oldSize, newSize);
        this.collectedCount = 0;
    }

    protected int getNodeWithHash(int hash) {
        return this.hashTable[hash];
    }

    protected void setHash(int hash, int index) {
        this.hashTable[hash] = index;
    }

    protected int hashNode(int lvl, int low, int high) {
        return Math.abs(HashCodeGenerator.generateHashCode(lvl, low, high) % this.nodeCount);
    }

    protected void doResize(int oldSize, int newSize) {
        int n;
        if (oldSize < (newSize = PrimeUtils.getLowerNextPrime(newSize))) {
            int[] newHashTable = new int[newSize];
            int[] newNextTable = new int[newSize];
            System.arraycopy(this.hashTable, 0, newHashTable, 0, this.hashTable.length);
            System.arraycopy(this.nextTable, 0, newNextTable, 0, this.nextTable.length);
            this.table.resize(newSize);
            this.nextTable = newNextTable;
            this.hashTable = newHashTable;
            this.nodeCount = newSize;
        }
        for (n = 0; n < oldSize; ++n) {
            this.setHash(n, 0);
        }
        for (n = oldSize; n < this.nodeCount; ++n) {
            this.setNext(n, n + 1);
        }
        this.setNext(this.nodeCount - 1, this.nextFree);
        this.freeCounter = this.nodeCount;
        this.rehash();
    }

    private void rehash() {
        this.nextFree = 0;
        for (int n = this.nodeCount - 1; n >= 2; --n) {
            V bdd;
            if (this.table.get(n) != null && (bdd = this.get(n)) != null) {
                int hash = this.hashNode(bdd.getVariable(), bdd.getLow().hashCode(), bdd.getHigh().hashCode());
                this.setNext(n, this.getNodeWithHash(hash));
                this.setHash(hash, n);
                --this.freeCounter;
                continue;
            }
            this.table.set(n, null);
            this.setNext(n, this.nextFree);
            this.nextFree = n;
        }
    }

    @Override
    public void rehash(V node, int oldHash) {
        int newHash = this.hashNode(node.getVariable(), node.getLow().hashCode(), node.getHigh().hashCode());
        if ((oldHash = Math.abs(oldHash % this.nodeCount)) != newHash) {
            int index = this.getNodeWithHash(oldHash);
            V res = this.get(index);
            int previous = index;
            while (res != node) {
                previous = index;
                index = this.getNext(index);
                res = this.get(index);
            }
            if (previous == index) {
                this.setHash(oldHash, this.getNext(index));
            } else {
                this.setNext(previous, this.getNext(index));
            }
            this.setNext(index, this.getNodeWithHash(newHash));
            this.setHash(newHash, index);
        }
    }

    protected int getNextFree() {
        int next = this.nextFree;
        this.nextFree = this.getNext(next);
        return next;
    }

    protected boolean checkResize() {
        return this.nextFree <= 1;
    }

    protected V get(int index) {
        return this.table.get(index);
    }

    @Override
    public V getHigh(V root) {
        return this.resolver.getHigh(root);
    }

    @Override
    public V getLow(V root) {
        return this.resolver.getLow(root);
    }

    @Override
    public V getTrue() {
        return this.one;
    }

    @Override
    public V getFalse() {
        return this.zero;
    }

    @Override
    public void shutDown() {
        this.clear();
    }

    @Override
    public DD.Factory<V> getFactory() {
        return this.factory;
    }

    @Override
    public int nodeCount() {
        return this.table.nodeCount();
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public void cleanUnusedNodes() {
        this.resizeTable();
    }

    @Override
    public void clear() {
        this.table = null;
        this.hashTable = null;
        this.nextTable = null;
    }
}

