/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.core.uniquetable;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.stream.Stream;
import org.sosy_lab.pjbdd.api.DD;

public class WeakDDArray<V extends DD> {
    protected WeakReference<?>[] table;
    protected final DD.ChildNodeResolver<V> resolver;
    protected final ReferenceQueue<V> referenceQueue;

    WeakDDArray(int size, DD.ChildNodeResolver<V> pResolver) {
        this.resolver = pResolver;
        this.table = new WeakReference[size];
        this.referenceQueue = new ReferenceQueue();
    }

    V get(int i) {
        if (this.table[i] == null) {
            return null;
        }
        return this.resolver.cast(this.table[i].get());
    }

    void set(int i, V value) {
        this.table[i] = new WeakReference<V>(value, this.referenceQueue);
    }

    Stream<V> toStream() {
        return Stream.of(this.table).filter(Objects::nonNull).map(ref -> this.resolver.cast(ref.get())).filter(Objects::nonNull);
    }

    void resize(int newSize) {
        WeakReference[] newUniqueTable = new WeakReference[newSize];
        System.arraycopy(this.table, 0, newUniqueTable, 0, this.table.length);
        this.table = newUniqueTable;
    }

    public int size() {
        return this.table.length;
    }

    public int nodeCount() {
        return (int)this.toStream().count();
    }
}

