/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.examples;

import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;

public class BitVectorExQuantExample {
    private BitVectorExQuantExample() {
    }

    public static void main(String[] args) {
        int vecN = 32;
        int varN = 10;
        BitVectorExQuantExample.bitvectorExquant(vecN, varN);
    }

    private static void bitvectorExquant(int vecN, int varN) {
        int i;
        varN = varN % 2 == 0 ? varN : varN + varN % 2;
        DD[][] varsi = new DD[varN][vecN];
        Creator creator = Builders.intBuilder().setTableSize(10).setThreads(1).setVarCount(vecN * varN).build();
        int var = 0;
        for (int j = 0; j < varN; ++j) {
            for (int i2 = 0; i2 < vecN; ++i2) {
                varsi[j][i2] = creator.makeIthVar(var++);
            }
        }
        DD[] chains = new DD[varN];
        for (int j = 0; j < varN; ++j) {
            chains[j] = creator.makeTrue();
            for (i = 0; i < vecN; ++i) {
                chains[j] = creator.makeAnd(chains[j], varsi[j][i]);
            }
        }
        DD chain = creator.makeTrue();
        i = 0;
        while (i < chains.length) {
            chain = creator.makeAnd(chain, creator.makeEqual(chains[i++], chains[i++]));
        }
        long start = System.currentTimeMillis();
        creator.makeExists(chain, chains[chains.length / 2]);
        System.out.println("Computation time: " + (System.currentTimeMillis() - start));
    }
}

