/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.examples;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.CreatorBuilder;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.examples.Example;

public class NQueens
implements Example {
    protected final Creator creator;
    protected final int theN;
    protected List<DD> board;
    protected DD queen;

    public NQueens(int n, Creator creator) {
        this.creator = creator;
        this.theN = n;
    }

    @Override
    public void build() {
        int i;
        this.queen = this.creator.makeTrue();
        this.board = new ArrayList<DD>(this.theN * this.theN);
        DD zero = this.creator.makeFalse();
        for (i = 0; i < this.theN; ++i) {
            for (int j = 0; j < this.theN; ++j) {
                this.set(this.creator.makeIthVar(i * this.theN + j));
            }
        }
        for (i = 0; i < this.theN; ++i) {
            DD f1 = zero;
            for (int j = 0; j < this.theN; ++j) {
                f1 = this.creator.makeOr(f1, this.get(i, j));
            }
            this.queen = this.creator.makeAnd(this.queen, f1);
        }
        for (i = 0; i < this.theN; ++i) {
            for (int j = 0; j < this.theN; ++j) {
                this.build(i, j);
            }
        }
    }

    @Override
    public BigInteger solve() {
        return this.creator.satCount(this.queen);
    }

    @Override
    public DD solution() {
        return this.queen;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"12", "12", "12", "12"};
        }
        for (Builders.TableType tableType : new Builders.TableType[]{Builders.TableType.CASArray}) {
            for (int i = 0; i < 2; ++i) {
                CreatorBuilder creatorbuilder = Builders.bddBuilder().setParallelizationType(Builders.ParallelizationType.NONE).setTableType(tableType).setVarCount(144).setTableSize(100000).setThreads(1).setCacheSize(10000);
                if (i == 1) {
                    System.out.println("Threadsafety disabled");
                    creatorbuilder.disableThreadSafety();
                }
                Creator creator = creatorbuilder.build();
                for (String str : args) {
                    int n = Integer.parseInt(str);
                    NQueens queens = new NQueens(n, creator);
                    long start = System.currentTimeMillis();
                    queens.build();
                    BigInteger count = queens.solve();
                    long end = System.currentTimeMillis();
                    System.out.println(tableType + " N=" + n + ":\n SatCount: " + count + "\n Duration: " + (end - start) + "ms");
                    queens.queen = null;
                    queens.board = null;
                    System.gc();
                }
                creator.shutDown();
            }
        }
    }

    protected void build(int i, int j) {
        DD f6;
        DD f5;
        int k;
        DD a = this.creator.makeTrue();
        DD b = this.creator.makeTrue();
        DD c = this.creator.makeTrue();
        DD d = this.creator.makeTrue();
        for (k = 0; k < this.theN; ++k) {
            if (k == j) continue;
            f5 = this.creator.makeNand(this.get(i, k), this.get(i, j));
            a = this.creator.makeAnd(a, f5);
        }
        for (k = 0; k < this.theN; ++k) {
            if (k == i) continue;
            f5 = this.creator.makeNand(this.get(i, j), this.get(k, j));
            b = this.creator.makeAnd(b, f5);
        }
        for (k = 0; k < this.theN; ++k) {
            int n = k - i + j;
            if (n < 0 || n >= this.theN || k == i) continue;
            f6 = this.creator.makeNand(this.get(i, j), this.get(k, n));
            c = this.creator.makeAnd(c, f6);
        }
        for (k = 0; k < this.theN; ++k) {
            int n = i + j - k;
            if (n < 0 || n >= this.theN || k == i) continue;
            f6 = this.creator.makeNand(this.get(i, j), this.get(k, n));
            d = this.creator.makeAnd(d, f6);
        }
        c = this.creator.makeAnd(c, d);
        b = this.creator.makeAnd(b, c);
        a = this.creator.makeAnd(a, b);
        this.queen = this.creator.makeAnd(this.queen, a);
    }

    private DD get(int row, int column) {
        return this.board.get(row * this.theN + column);
    }

    private void set(DD value) {
        this.board.add(value);
    }

    @Override
    public void close() {
        this.queen = null;
        this.board = null;
        this.creator.shutDown();
    }
}

